/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.objects.filters;

import java.util.Set;
import org.dizitart.no2.Document;
import org.dizitart.no2.Filter;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.filters.Filters;
import org.dizitart.no2.objects.filters.BaseObjectFilter;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.util.ValidationUtils;

class GreaterEqualObjectFilter
extends BaseObjectFilter {
    private String field;
    private Object value;

    GreaterEqualObjectFilter(String field, Object value) {
        this.field = field;
        this.value = value;
    }

    @Override
    public Set<NitriteId> apply(NitriteMap<NitriteId, Document> documentMap) {
        ValidationUtils.validateSearchTerm(this.nitriteMapper, this.field, this.value);
        Comparable comparable = this.nitriteMapper.isValueType(this.value) ? (Comparable)this.nitriteMapper.asValue(this.value) : (Comparable)this.value;
        Filter gte = Filters.gte(this.field, comparable);
        gte.setNitriteService(this.nitriteService);
        return gte.apply(documentMap);
    }

    public String getField() {
        return this.field;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return "GreaterEqualObjectFilter(field=" + this.getField() + ", value=" + this.getValue() + ")";
    }
}

