/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2;

import java.io.Serializable;
import org.dizitart.no2.ObjectId;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.InvalidIdException;

public final class NitriteId
implements Comparable<NitriteId>,
Serializable {
    private static final long serialVersionUID = 1477462375L;
    private Long idValue;

    private NitriteId() {
        this.idValue = new ObjectId().toLong();
    }

    private NitriteId(Long value) {
        this.idValue = value;
    }

    public static NitriteId newId() {
        try {
            return new NitriteId();
        }
        catch (Exception e) {
            throw new InvalidIdException(ErrorMessage.FAILED_TO_CREATE_AUTO_ID, (Throwable)e);
        }
    }

    public static NitriteId createId(Long value) {
        return new NitriteId(value);
    }

    @Override
    public int compareTo(NitriteId other) {
        if (other == null || other.idValue == null) {
            throw new InvalidIdException(ErrorMessage.CAN_NOT_COMPARE_WITH_NULL_ID);
        }
        return Long.compare(this.idValue, other.idValue);
    }

    public String toString() {
        if (this.idValue != null) {
            return "[" + this.idValue.toString() + "]NO\u2082";
        }
        return "";
    }

    public Long getIdValue() {
        if (this.idValue != null) {
            return this.idValue;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NitriteId)) {
            return false;
        }
        NitriteId other = (NitriteId)o;
        Long this$idValue = this.getIdValue();
        Long other$idValue = other.getIdValue();
        return !(this$idValue == null ? other$idValue != null : !((Object)this$idValue).equals(other$idValue));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idValue = this.getIdValue();
        result = result * 59 + ($idValue == null ? 43 : ((Object)$idValue).hashCode());
        return result;
    }
}

