/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2;

import java.io.Closeable;
import java.nio.channels.NonWritableChannelException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.dizitart.no2.Document;
import org.dizitart.no2.NitriteBuilder;
import org.dizitart.no2.NitriteCollection;
import org.dizitart.no2.NitriteContext;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.Security;
import org.dizitart.no2.internals.CollectionFactory;
import org.dizitart.no2.objects.ObjectRepository;
import org.dizitart.no2.objects.RepositoryFactory;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteStore;
import org.dizitart.no2.util.ObjectUtils;
import org.dizitart.no2.util.StringUtils;
import org.dizitart.no2.util.ValidationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Nitrite
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(Nitrite.class);
    private NitriteStore store;
    private NitriteContext context;

    Nitrite(NitriteStore store, NitriteContext nitriteContext) {
        this.context = nitriteContext;
        this.store = store;
    }

    public static NitriteBuilder builder() {
        return new NitriteBuilder();
    }

    public NitriteCollection getCollection(String name) {
        ValidationUtils.validateCollectionName(name);
        if (this.store != null) {
            NitriteMap<NitriteId, Document> mapStore = this.store.openMap(name);
            return CollectionFactory.open(mapStore, this.context);
        }
        log.error("Underlying store is null. Nitrite has not been initialized properly.");
        return null;
    }

    public <T> ObjectRepository<T> getRepository(Class<T> type) {
        if (this.store != null) {
            String name = ObjectUtils.findObjectStoreName(type);
            NitriteMap<NitriteId, Document> mapStore = this.store.openMap(name);
            NitriteCollection collection = CollectionFactory.open(mapStore, this.context);
            return RepositoryFactory.open(type, collection, this.context);
        }
        log.error("Underlying store is null. Nitrite has not been initialized properly.");
        return null;
    }

    public Set<String> listCollectionNames() {
        LinkedHashSet<String> collectionNames = new LinkedHashSet<String>();
        if (this.store != null) {
            for (String name : this.store.getMapNames()) {
                if (!ValidationUtils.isValidCollectionName(name) || ObjectUtils.isObjectStore(name)) continue;
                collectionNames.add(name);
            }
        } else {
            log.error("Underlying store is null. Nitrite has not been initialized properly.");
        }
        return collectionNames;
    }

    public Set<String> listRepositories() {
        LinkedHashSet<String> repositoryNames = new LinkedHashSet<String>();
        if (this.store != null) {
            for (String name : this.store.getMapNames()) {
                String objectType;
                if (name.contains("|") || name.contains("$nitrite_users") || StringUtils.isNullOrEmpty(objectType = ObjectUtils.findObjectTypeName(name))) continue;
                repositoryNames.add(objectType);
            }
        } else {
            log.error("Underlying store is null. Nitrite has not been initialized properly.");
        }
        return repositoryNames;
    }

    public boolean hasCollection(String name) {
        return this.listCollectionNames().contains(name);
    }

    public <T> boolean hasRepository(Class<T> type) {
        return this.listRepositories().contains(type.getName());
    }

    public boolean hasUnsavedChanges() {
        return this.store != null && this.store.hasUnsavedChanges();
    }

    public void compact() {
        if (this.store != null && !this.store.isClosed() && !this.context.isReadOnly()) {
            this.store.compactMoveChunks();
            if (log.isDebugEnabled()) {
                log.debug("Store compaction is successful.");
            }
        } else if (this.store == null) {
            log.error("Underlying store is null. Nitrite has not been initialized properly.");
        }
    }

    public void commit() {
        if (this.store != null && !this.context.isReadOnly()) {
            this.store.commit();
            if (log.isDebugEnabled()) {
                log.debug("Unsaved changes committed successfully.");
            }
        } else if (this.store == null) {
            log.error("Underlying store is null. Nitrite has not been initialized properly.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() {
        if (this.store != null) {
            try {
                if (this.hasUnsavedChanges()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Unsaved changes detected, committing the changes.");
                    }
                    this.commit();
                }
                if (this.context.isAutoCompactEnabled()) {
                    this.compact();
                }
                try {
                    this.closeCollections();
                    this.context.shutdown();
                }
                catch (Throwable error) {
                    log.error("Error while shutting down nitrite.", error);
                }
                this.store.close();
                return;
            }
            catch (NonWritableChannelException error) {
                if (this.context.isReadOnly()) return;
                throw error;
            }
            finally {
                this.store = null;
                log.info("Nitrite database has been closed successfully.");
            }
        }
        log.error("Underlying store is null. Nitrite has not been initialized properly.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void closeImmediately() {
        if (this.store != null) {
            try {
                this.store.closeImmediately();
                this.context.shutdown();
                return;
            }
            catch (NonWritableChannelException error) {
                if (this.context.isReadOnly()) return;
                log.error("Error while closing nitrite store.", (Throwable)error);
                return;
            }
            catch (Throwable t) {
                log.error("Error while closing nitrite store.", t);
                return;
            }
            finally {
                this.store = null;
                log.info("Nitrite database has been closed by JVM shutdown hook without saving last unsaved changes.");
            }
        } else {
            log.error("Underlying store is null. Nitrite has not been initialized properly.");
        }
    }

    public boolean isClosed() {
        return this.store == null || this.store.isClosed();
    }

    public boolean validateUser(String userId, String password) {
        return Security.validateUserPassword(this.store, userId, password);
    }

    private void closeCollections() {
        List<Class<?>> repositories;
        List<String> collections = this.context.getCollectionRegistry();
        if (collections != null) {
            for (String name : collections) {
                NitriteCollection collection = this.getCollection(name);
                if (collection == null || collection.isClosed()) continue;
                collection.close();
            }
            collections.clear();
        }
        if ((repositories = this.context.getRepositoryRegistry()) != null) {
            for (Class<?> type : repositories) {
                ObjectRepository<?> repository = this.getRepository(type);
                if (repository == null || repository.isClosed()) continue;
                repository.close();
            }
            repositories.clear();
        }
    }

    public NitriteContext getContext() {
        return this.context;
    }
}

