/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.swarm.fitness;

import java.util.ArrayList;
import java.util.List;
import org.dishevelled.functor.BinaryFunction;
import org.dishevelled.swarm.Fitness;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeFitness
implements Fitness {
    private final List<Fitness> children;
    private final BinaryFunction<Double, Double, Double> aggregate;

    public CompositeFitness(List<Fitness> children, BinaryFunction<Double, Double, Double> aggregate) {
        if (children == null) {
            throw new IllegalArgumentException("children must not be null");
        }
        if (children.isEmpty()) {
            throw new IllegalArgumentException("children must contain at least one fitness function");
        }
        if (aggregate == null) {
            throw new IllegalArgumentException("aggregate must not be null");
        }
        this.children = new ArrayList<Fitness>(children);
        this.aggregate = aggregate;
    }

    @Override
    public double score(double[] position) {
        int last = this.children.size() - 1;
        double rv = this.children.get(last).score(position);
        int i = last;
        while (--i >= 0) {
            rv = (Double)this.aggregate.evaluate((Object)rv, (Object)this.children.get(i).score(position));
        }
        return rv;
    }
}

