/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.swarm;

import java.util.EventObject;
import org.dishevelled.swarm.ParticleSwarm;
import org.dishevelled.swarm.ParticleSwarmOptimizationAlgorithm;

public final class ParticleSwarmOptimizationAlgorithmEvent
extends EventObject {
    private ParticleSwarm swarm;
    private final int epoch;
    private final int particle;
    private final int dimension;
    private final double value;
    private final double fitness;
    public static final int DEFAULT_EPOCH = -1;
    public static final int DEFAULT_PARTICLE = -1;
    public static final int DEFAULT_DIMENSION = -1;
    public static final double DEFAULT_VALUE = Double.NaN;
    public static final double DEFAULT_FITNESS = Double.NaN;

    ParticleSwarmOptimizationAlgorithmEvent(ParticleSwarmOptimizationAlgorithm source, ParticleSwarm swarm, int epoch) {
        super(source);
        if (swarm == null) {
            throw new IllegalArgumentException("swarm must not be null");
        }
        this.swarm = swarm;
        this.epoch = epoch;
        this.particle = -1;
        this.dimension = -1;
        this.value = Double.NaN;
        this.fitness = Double.NaN;
    }

    ParticleSwarmOptimizationAlgorithmEvent(ParticleSwarmOptimizationAlgorithm source, int particle, int dimension, double value) {
        super(source);
        this.swarm = null;
        this.epoch = -1;
        this.particle = particle;
        this.dimension = dimension;
        this.value = value;
        this.fitness = Double.NaN;
    }

    ParticleSwarmOptimizationAlgorithmEvent(ParticleSwarmOptimizationAlgorithm source, int particle, int dimension, double value, double fitness) {
        super(source);
        this.swarm = null;
        this.epoch = -1;
        this.particle = particle;
        this.dimension = dimension;
        this.value = value;
        this.fitness = fitness;
    }

    public ParticleSwarmOptimizationAlgorithm getParticleSwarmOptimizationAlgorithm() {
        return (ParticleSwarmOptimizationAlgorithm)super.getSource();
    }

    public ParticleSwarm getParticleSwarm() {
        return this.swarm;
    }

    public int getEpoch() {
        return this.epoch;
    }

    public int getParticle() {
        return this.particle;
    }

    public int getDimension() {
        return this.dimension;
    }

    public double getValue() {
        return this.value;
    }

    public double getFitness() {
        return this.fitness;
    }
}

