/*
 * Decompiled with CFR 0.152.
 */
package org.dishevelled.swarm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Random;
import javax.swing.event.EventListenerList;
import org.dishevelled.swarm.ExitStrategy;
import org.dishevelled.swarm.Fitness;
import org.dishevelled.swarm.ParticleSwarm;
import org.dishevelled.swarm.ParticleSwarmImpl;
import org.dishevelled.swarm.ParticleSwarmOptimizationAlgorithmEvent;
import org.dishevelled.swarm.ParticleSwarmOptimizationAlgorithmListener;

public final class ParticleSwarmOptimizationAlgorithm {
    private final EventListenerList listenerList = new EventListenerList();
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Random random = new Random();
    private double inertiaWeight = 0.1;
    private double cognitiveWeight = 0.2;
    private double socialWeight = 0.2;
    private double minimumPosition = 0.0;
    private double maximumPosition = 1.0;
    private double minimumVelocity = -0.5;
    private double maximumVelocity = 0.5;
    public static final double DEFAULT_INERTIA_WEIGHT = 0.1;
    public static final double DEFAULT_COGNITIVE_WEIGHT = 0.2;
    public static final double DEFAULT_SOCIAL_WEIGHT = 0.2;
    public static final double DEFAULT_MINIMUM_POSITION = 0.0;
    public static final double DEFAULT_MAXIMUM_POSITION = 1.0;
    public static final double DEFAULT_MINIMUM_VELOCITY = -0.5;
    public static final double DEFAULT_MAXIMUM_VELOCITY = 0.5;

    public ParticleSwarm optimize(int particles, int dimensions, ExitStrategy exitStrategy, Fitness fitness) {
        if (exitStrategy == null) {
            throw new IllegalArgumentException("exitStrategy must not be null");
        }
        if (fitness == null) {
            throw new IllegalArgumentException("fitness must not be null");
        }
        ParticleSwarmImpl swarm = new ParticleSwarmImpl(particles, dimensions);
        double range = Math.abs(this.maximumPosition - this.minimumPosition);
        for (int particle = 0; particle < particles; ++particle) {
            for (int dimension = 0; dimension < dimensions; ++dimension) {
                double r = this.random.nextDouble() * range + this.minimumPosition;
                swarm.setPosition(particle, dimension, r);
                swarm.setFitness(particle, -1.7976931348623157E308);
            }
        }
        int epoch = 0;
        while (!exitStrategy.evaluate(swarm, epoch)) {
            this.fireExitFailed(swarm, epoch);
            for (int particle = 0; particle < particles; ++particle) {
                for (int dimension = 0; dimension < dimensions; ++dimension) {
                    double r1 = this.random.nextDouble();
                    double r2 = this.random.nextDouble();
                    double x = swarm.getPosition(particle, dimension);
                    double v = swarm.getVelocity(particle, dimension);
                    double p = swarm.getCognitiveMemory(particle, dimension);
                    double s = swarm.getSocialMemory(dimension);
                    v = this.inertiaWeight * v + this.cognitiveWeight * r1 * (p - x) + this.socialWeight * r2 * (s - x);
                    v = Math.max(v, this.minimumVelocity);
                    v = Math.min(v, this.maximumVelocity);
                    swarm.setVelocity(particle, dimension, v);
                    this.fireVelocityCalculated(particle, dimension, v);
                    x += v;
                    x = Math.max(x, this.minimumPosition);
                    x = Math.min(x, this.maximumPosition);
                    swarm.setPosition(particle, dimension, x);
                    this.firePositionUpdated(particle, dimension, x);
                }
                double fx = fitness.score(swarm.getPosition(particle));
                swarm.setFitness(particle, fx);
                this.fireFitnessCalculated(particle, fx);
                double fp = fitness.score(swarm.getCognitiveMemory(particle));
                double fs = fitness.score(swarm.getSocialMemory());
                if (fx > fp) {
                    swarm.updateCognitiveMemory(particle);
                }
                if (!(fx > fs)) continue;
                swarm.updateSocialMemory(particle);
            }
            ++epoch;
        }
        this.fireExitSucceeded(swarm, epoch);
        return swarm;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        if (random == null) {
            throw new IllegalArgumentException("random must not be null");
        }
        Random oldRandom = this.random;
        this.random = random;
        this.propertyChangeSupport.firePropertyChange("random", oldRandom, this.random);
    }

    public double getInertiaWeight() {
        return this.inertiaWeight;
    }

    public void setInertiaWeight(double inertiaWeight) {
        double oldInertiaWeight = this.inertiaWeight;
        this.inertiaWeight = inertiaWeight;
        this.propertyChangeSupport.firePropertyChange("inertiaWeight", oldInertiaWeight, this.inertiaWeight);
    }

    public double getCognitiveWeight() {
        return this.cognitiveWeight;
    }

    public void setCognitiveWeight(double cognitiveWeight) {
        double oldCognitiveWeight = this.cognitiveWeight;
        this.cognitiveWeight = cognitiveWeight;
        this.propertyChangeSupport.firePropertyChange("cognitiveWeight", oldCognitiveWeight, this.cognitiveWeight);
    }

    public double getSocialWeight() {
        return this.socialWeight;
    }

    public void setSocialWeight(double socialWeight) {
        double oldSocialWeight = this.socialWeight;
        this.socialWeight = socialWeight;
        this.propertyChangeSupport.firePropertyChange("socialWeight", oldSocialWeight, this.socialWeight);
    }

    public double getMinimumPosition() {
        return this.minimumPosition;
    }

    public void setMinimumPosition(double minimumPosition) {
        double oldMinimumPosition = this.minimumPosition;
        this.minimumPosition = minimumPosition;
        this.propertyChangeSupport.firePropertyChange("minimumPosition", oldMinimumPosition, this.minimumPosition);
    }

    public double getMaximumPosition() {
        return this.maximumPosition;
    }

    public void setMaximumPosition(double maximumPosition) {
        double oldMaximumPosition = this.maximumPosition;
        this.maximumPosition = maximumPosition;
        this.propertyChangeSupport.firePropertyChange("maximumPosition", oldMaximumPosition, this.maximumPosition);
    }

    public double getMinimumVelocity() {
        return this.minimumVelocity;
    }

    public void setMinimumVelocity(double minimumVelocity) {
        double oldMinimumVelocity = this.minimumVelocity;
        this.minimumVelocity = minimumVelocity;
        this.propertyChangeSupport.firePropertyChange("minimumVelocity", oldMinimumVelocity, this.minimumVelocity);
    }

    public double getMaximumVelocity() {
        return this.maximumVelocity;
    }

    public void setMaximumVelocity(double maximumVelocity) {
        double oldMaximumVelocity = this.maximumVelocity;
        this.maximumVelocity = maximumVelocity;
        this.propertyChangeSupport.firePropertyChange("maximumVelocity", oldMaximumVelocity, this.maximumVelocity);
    }

    public void addParticleSwarmOptimizationAlgorithmListener(ParticleSwarmOptimizationAlgorithmListener l) {
        this.listenerList.add(ParticleSwarmOptimizationAlgorithmListener.class, l);
    }

    public void removeParticleSwarmOptimizationAlgorithmListener(ParticleSwarmOptimizationAlgorithmListener l) {
        this.listenerList.remove(ParticleSwarmOptimizationAlgorithmListener.class, l);
    }

    public int getParticleSwarmOptimizationAlgorithmListenerCount() {
        return this.listenerList.getListenerCount(ParticleSwarmOptimizationAlgorithmListener.class);
    }

    public ParticleSwarmOptimizationAlgorithmListener[] getParticleSwarmOptimizationAlgorithmListeners() {
        return (ParticleSwarmOptimizationAlgorithmListener[])this.listenerList.getListeners(ParticleSwarmOptimizationAlgorithmListener.class);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public int getPropertyChangeListenerCount() {
        return this.propertyChangeSupport.getPropertyChangeListeners().length;
    }

    public int getPropertyChangeListenerCount(String propertyName) {
        return this.propertyChangeSupport.getPropertyChangeListeners(propertyName).length;
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.propertyChangeSupport.getPropertyChangeListeners(propertyName);
    }

    private void fireExitFailed(ParticleSwarm swarm, int epoch) {
        Object[] listeners = this.listenerList.getListenerList();
        ParticleSwarmOptimizationAlgorithmEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ParticleSwarmOptimizationAlgorithmListener.class) continue;
            if (e == null) {
                e = new ParticleSwarmOptimizationAlgorithmEvent(this, swarm, epoch);
            }
            ((ParticleSwarmOptimizationAlgorithmListener)listeners[i + 1]).exitFailed(e);
        }
    }

    private void fireExitSucceeded(ParticleSwarm swarm, int epoch) {
        Object[] listeners = this.listenerList.getListenerList();
        ParticleSwarmOptimizationAlgorithmEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ParticleSwarmOptimizationAlgorithmListener.class) continue;
            if (e == null) {
                e = new ParticleSwarmOptimizationAlgorithmEvent(this, swarm, epoch);
            }
            ((ParticleSwarmOptimizationAlgorithmListener)listeners[i + 1]).exitSucceeded(e);
        }
    }

    private void fireVelocityCalculated(int particle, int dimension, double velocity) {
        Object[] listeners = this.listenerList.getListenerList();
        ParticleSwarmOptimizationAlgorithmEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ParticleSwarmOptimizationAlgorithmListener.class) continue;
            if (e == null) {
                e = new ParticleSwarmOptimizationAlgorithmEvent(this, particle, dimension, velocity);
            }
            ((ParticleSwarmOptimizationAlgorithmListener)listeners[i + 1]).velocityCalculated(e);
        }
    }

    private void firePositionUpdated(int particle, int dimension, double position) {
        Object[] listeners = this.listenerList.getListenerList();
        ParticleSwarmOptimizationAlgorithmEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ParticleSwarmOptimizationAlgorithmListener.class) continue;
            if (e == null) {
                e = new ParticleSwarmOptimizationAlgorithmEvent(this, particle, dimension, position);
            }
            ((ParticleSwarmOptimizationAlgorithmListener)listeners[i + 1]).positionUpdated(e);
        }
    }

    private void fireFitnessCalculated(int particle, double fitness) {
        Object[] listeners = this.listenerList.getListenerList();
        ParticleSwarmOptimizationAlgorithmEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ParticleSwarmOptimizationAlgorithmListener.class) continue;
            if (e == null) {
                e = new ParticleSwarmOptimizationAlgorithmEvent(this, particle, 0, 0.0, fitness);
            }
            ((ParticleSwarmOptimizationAlgorithmListener)listeners[i + 1]).fitnessCalculated(e);
        }
    }

    private void fireCognitiveMemoryUpdated(int particle, int dimension, double position) {
        Object[] listeners = this.listenerList.getListenerList();
        ParticleSwarmOptimizationAlgorithmEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ParticleSwarmOptimizationAlgorithmListener.class) continue;
            if (e == null) {
                e = new ParticleSwarmOptimizationAlgorithmEvent(this, particle, dimension, position);
            }
            ((ParticleSwarmOptimizationAlgorithmListener)listeners[i + 1]).cognitiveMemoryUpdated(e);
        }
    }

    private void fireSocialMemoryUpdated(int particle, int dimension, double position) {
        Object[] listeners = this.listenerList.getListenerList();
        ParticleSwarmOptimizationAlgorithmEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ParticleSwarmOptimizationAlgorithmListener.class) continue;
            if (e == null) {
                e = new ParticleSwarmOptimizationAlgorithmEvent(this, particle, dimension, position);
            }
            ((ParticleSwarmOptimizationAlgorithmListener)listeners[i + 1]).socialMemoryUpdated(e);
        }
    }
}

