/*
 * Decompiled with CFR 0.152.
 */
package org.getahead.dwrdemo.gidemo;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

public class Corporation {
    private String jsxid;
    private String name;
    private BigDecimal last;
    private Date time;
    private BigDecimal change;
    private BigDecimal max;
    private BigDecimal min;
    private Random random = new Random();
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("hh:MM:ss");

    public Corporation(String jsxid, String name) {
        this.jsxid = jsxid;
        this.name = name;
        float temp = this.random.nextFloat() * 100.0f;
        this.last = new BigDecimal((float)Math.round(temp * 100.0f) / 100.0f);
        this.last = this.last.setScale(2, 0);
        this.time = new Date();
        this.change = new BigDecimal(0.0);
        this.change = this.change.setScale(2, 0);
        this.max = this.last;
        this.min = this.last;
    }

    public String getJsxid() {
        return this.jsxid;
    }

    public String getName() {
        return this.name;
    }

    public BigDecimal getLast() {
        return this.last;
    }

    public String getTime() {
        return FORMAT.format(this.time);
    }

    public BigDecimal getChange() {
        return this.change;
    }

    public BigDecimal getMax() {
        return this.max;
    }

    public BigDecimal getMin() {
        return this.min;
    }

    public void change() {
        float newChange = this.random.nextFloat() * 4.0f - 2.0f;
        newChange = (float)Math.round(newChange * 100.0f) / 100.0f;
        if (this.last.floatValue() + newChange < 9.0f) {
            newChange = -newChange;
        }
        this.change = new BigDecimal(newChange);
        this.change = this.change.setScale(2, 0);
        this.last = this.last.add(this.change);
        if (this.last.compareTo(this.max) > 0) {
            this.max = this.last;
        }
        if (this.last.compareTo(this.min) < 0) {
            this.min = this.last;
        }
        this.time = new Date();
    }
}

