/*
 * Decompiled with CFR 0.152.
 */
package org.diirt.datasource.test;

import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.diirt.datasource.ExceptionHandler;

public class CountDownWriteFunction
extends ExceptionHandler {
    private volatile CountDownLatch latch;
    private volatile Exception exception;

    public CountDownWriteFunction(int count) {
        this.latch = new CountDownLatch(count);
    }

    public void handleException(Exception esception) {
        this.exception = esception;
        this.latch.countDown();
    }

    public void resetCount(int count) {
        this.latch = new CountDownLatch(count);
    }

    public int getCount() {
        return (int)this.latch.getCount();
    }

    public boolean await(Duration duration) throws InterruptedException {
        return this.latch.await(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public Exception getException() {
        return this.exception;
    }
}

