/*
 * Decompiled with CFR 0.152.
 */
package org.diirt.datasource.test;

import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.diirt.datasource.PVWriterEvent;
import org.diirt.datasource.PVWriterListener;

public class CountDownPVWriterListener<T>
implements PVWriterListener<T> {
    private volatile CountDownLatch latch;
    private volatile PVWriterEvent<T> event;
    private volatile String threadName;
    private AtomicInteger notificationCount = new AtomicInteger();

    public CountDownPVWriterListener(int count) {
        this.latch = new CountDownLatch(count);
    }

    public void pvChanged(PVWriterEvent<T> event) {
        this.event = event;
        this.notificationCount.incrementAndGet();
        this.threadName = Thread.currentThread().getName();
        this.latch.countDown();
    }

    public void resetCount(int count) {
        this.latch = new CountDownLatch(count);
    }

    public int getCount() {
        return (int)this.latch.getCount();
    }

    public PVWriterEvent<T> getEvent() {
        return this.event;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public int getNotificationCount() {
        return this.notificationCount.get();
    }

    public boolean await(Duration duration) throws InterruptedException {
        return this.latch.await(duration.toNanos(), TimeUnit.NANOSECONDS);
    }
}

