/*
 * Decompiled with CFR 0.152.
 */
package org.diirt.datasource.test;

import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.diirt.datasource.PVReaderEvent;
import org.diirt.datasource.PVReaderListener;

public class CountDownPVReaderListener
implements PVReaderListener<Object> {
    private volatile CountDownLatch latch;
    private volatile PVReaderEvent<Object> event;
    private final int mask;

    public CountDownPVReaderListener(int count) {
        this(count, PVReaderEvent.CONNECTION_MASK | PVReaderEvent.EXCEPTION_MASK | PVReaderEvent.VALUE_MASK);
    }

    public CountDownPVReaderListener(int count, int mask) {
        this.latch = new CountDownLatch(count);
        this.mask = mask;
    }

    public void pvChanged(PVReaderEvent<Object> event) {
        if ((event.getNotificationMask() & this.mask) != 0) {
            this.event = event;
            this.latch.countDown();
        }
    }

    public void resetCount(int count) {
        this.latch = new CountDownLatch(count);
    }

    public int getCount() {
        return (int)this.latch.getCount();
    }

    public boolean await(Duration duration) throws InterruptedException {
        return this.latch.await(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public PVReaderEvent<Object> getEvent() {
        return this.event;
    }
}

