/*
 * Decompiled with CFR 0.152.
 */
package org.diirt.datasource.file;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.diirt.datasource.file.FileWatcherService;

public class FileWatcherPollingService
implements FileWatcherService {
    private static final Logger log = Logger.getLogger(FileWatcherService.class.getName());
    private final Object lock = new Object();
    private final ScheduledExecutorService exec;
    private final Runnable scanTask = new Runnable(){

        @Override
        public void run() {
            FileWatcherPollingService.this.scan();
        }
    };
    private final List<Registration> registrations = new ArrayList<Registration>();

    public FileWatcherPollingService(ScheduledExecutorService exec, Duration scanRate) {
        this.exec = exec;
        exec.scheduleWithFixedDelay(this.scanTask, 0L, scanRate.toNanos(), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWatcher(File file, Runnable callback) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.registrations.add(new Registration(file, callback));
            }
            catch (IOException ex) {
                log.log(Level.WARNING, "Notifications won't be enable for file " + file, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWatcher(File file, Runnable callback) {
        Object object = this.lock;
        synchronized (object) {
            Registration toClose = null;
            for (Registration registration : this.registrations) {
                if (!registration.file.equals(file) || !registration.callback.equals(callback)) continue;
                toClose = registration;
            }
            this.registrations.remove(toClose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan() {
        Object object = this.lock;
        synchronized (object) {
            for (Registration registration : this.registrations) {
                registration.notifyChanges();
            }
        }
    }

    private class Registration {
        final File file;
        final Runnable callback;
        Long previousTime;

        Registration(File file, Runnable callback) throws IOException {
            this.file = file;
            this.callback = callback;
        }

        void notifyChanges() {
            long latestTime = this.file.lastModified();
            if (this.previousTime == null || latestTime != this.previousTime) {
                this.previousTime = latestTime;
                try {
                    this.callback.run();
                }
                catch (RuntimeException ex) {
                    log.log(Level.WARNING, "Exception on the file watcher callback", ex);
                }
            }
        }
    }
}

