/*
 * Decompiled with CFR 0.152.
 */
package org.diirt.datasource.file;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.diirt.datasource.file.FileFormat;
import org.diirt.util.config.ServiceLoaderOSGiWrapper;

public class FileFormatRegistry {
    private static final FileFormatRegistry registry = new FileFormatRegistry();
    private static final Map<String, FileFormat> fileFormatRegistry = new ConcurrentHashMap<String, FileFormat>();
    private static final Logger log = Logger.getLogger(FileFormatRegistry.class.getName());

    public static FileFormatRegistry getDefault() {
        return registry;
    }

    public void registerFileFormat(String extension, FileFormat format) {
        log.log(Level.FINE, "File datasource: registering extension {0}", extension);
        fileFormatRegistry.put(extension, format);
    }

    public void registerFileFormat(FileFormat format) {
        for (String extension : format.getFileExtensions()) {
            this.registerFileFormat(extension, format);
        }
    }

    public FileFormat getFileFormatFor(String extension) {
        return fileFormatRegistry.get(extension);
    }

    public boolean contains(String extension) {
        return fileFormatRegistry.containsKey(extension);
    }

    static {
        ServiceLoaderOSGiWrapper.load(FileFormat.class, (Logger)log, registry::registerFileFormat);
    }
}

