/*
 * Decompiled with CFR 0.152.
 */
package org.diirt.datasource.file;

import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.diirt.datasource.DataSourceConfiguration;
import org.diirt.datasource.file.FileDataSource;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class FileDataSourceConfiguration
extends DataSourceConfiguration<FileDataSource> {
    boolean pollEnabled = false;
    Duration pollInterval = Duration.ofSeconds(5L);

    public FileDataSourceConfiguration read(InputStream input) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(input);
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xPath = xpathFactory.newXPath();
            String ver = xPath.evaluate("/file/@version", document);
            if (!ver.equals("1")) {
                throw new IllegalArgumentException("Unsupported version " + ver);
            }
            String intervalDuration = xPath.evaluate("/file/poll/@interval", document);
            if (intervalDuration != null && !intervalDuration.isEmpty()) {
                this.pollEnabled = true;
                this.pollInterval = Duration.ofSeconds(Long.parseLong(intervalDuration));
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException ex) {
            Logger.getLogger(FileDataSourceConfiguration.class.getName()).log(Level.FINEST, "Couldn't load file configuration", ex);
            throw new IllegalArgumentException("Couldn't load file configuration", ex);
        }
        return this;
    }

    public Duration getPollInterval() {
        return this.pollInterval;
    }

    public FileDataSourceConfiguration pollInterval(Duration pollInterval) {
        this.pollInterval = pollInterval;
        return this;
    }

    public boolean isPollEnabled() {
        return this.pollEnabled;
    }

    public FileDataSourceConfiguration pollEnabled(boolean pollEnabled) {
        this.pollEnabled = pollEnabled;
        return this;
    }

    public FileDataSource create() {
        return new FileDataSource(this);
    }
}

