/*
 * Decompiled with CFR 0.152.
 */
package org.diirt.datasource.file;

import java.io.File;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import org.diirt.datasource.ChannelHandler;
import org.diirt.datasource.DataSource;
import org.diirt.datasource.file.CSVFileFormat;
import org.diirt.datasource.file.FileChannelHandler;
import org.diirt.datasource.file.FileDataSourceConfiguration;
import org.diirt.datasource.file.FileFormatRegistry;
import org.diirt.datasource.file.FileWatcherFileSystemService;
import org.diirt.datasource.file.FileWatcherPollingService;
import org.diirt.datasource.file.FileWatcherService;
import org.diirt.datasource.vtype.DataTypeSupport;
import org.diirt.util.concurrent.Executors;

public final class FileDataSource
extends DataSource {
    private static final FileFormatRegistry register = FileFormatRegistry.getDefault();
    private final ScheduledExecutorService exec = java.util.concurrent.Executors.newSingleThreadScheduledExecutor(Executors.namedPool((String)"diirt - file watch"));
    private final FileWatcherService fileWatchService;

    FileDataSource(FileDataSourceConfiguration conf) {
        super(true);
        this.fileWatchService = conf.isPollEnabled() ? new FileWatcherPollingService(this.exec, conf.pollInterval) : new FileWatcherFileSystemService(this.exec, Duration.ofSeconds(1L));
    }

    FileWatcherService getFileWatchService() {
        return this.fileWatchService;
    }

    protected ChannelHandler createChannel(String channelName) {
        String fileExt;
        if (channelName.contains(".") && register.contains(fileExt = channelName.substring(channelName.lastIndexOf(46) + 1, channelName.length()))) {
            return new FileChannelHandler(this, channelName, new File(URI.create("file://" + channelName)), register.getFileFormatFor(fileExt));
        }
        return new FileChannelHandler(this, channelName, new File(URI.create("file://" + channelName)), new CSVFileFormat());
    }

    public void close() {
        this.exec.shutdownNow();
        super.close();
    }

    static {
        DataTypeSupport.install();
    }
}

