/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public class SatisfyingRevocationDataExistsCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final CertificateWrapper certificateWrapper;
    private final RevocationWrapper revocationData;
    private final Date controlTime;

    public SatisfyingRevocationDataExistsCheck(I18nProvider i18nProvider, T result, CertificateWrapper certificateWrapper, RevocationWrapper revocationData, Date controlTime, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.certificateWrapper = certificateWrapper;
        this.revocationData = revocationData;
        this.controlTime = controlTime;
    }

    @Override
    protected boolean process() {
        return this.revocationData != null;
    }

    @Override
    protected String buildAdditionalInfo() {
        if (this.revocationData != null) {
            return this.i18nProvider.getMessage(MessageTag.CERTIFICATE_REVOCATION_FOUND, new Object[]{this.revocationData.getId(), this.certificateWrapper.getId(), ValidationProcessUtils.getFormattedDate(this.controlTime)});
        }
        return this.i18nProvider.getMessage(MessageTag.CERTIFICATE_REVOCATION_NOT_FOUND, new Object[]{this.certificateWrapper.getId(), ValidationProcessUtils.getFormattedDate(this.controlTime)});
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_VTS_IRDPFC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_VTS_IRDPFC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.NO_POE;
    }
}

