/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRAC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRFC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlVTS;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.RevocationReason;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.Model;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.CertificateAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.RevocationAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationAcceptanceCheckerResultCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.RevocationFreshnessChecker;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.RevocationDataAcceptableCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.checks.POEExistsAtOrBeforeControlTimeCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.checks.RevocationIssuedBeforeControlTimeCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.checks.SatisfyingRevocationDataExistsCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ValidationTimeSliding
extends Chain<XmlVTS> {
    private final TokenProxy token;
    private final Date currentTime;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final Context context;
    private final POEExtraction poe;
    private final ValidationPolicy policy;
    private Date controlTime;

    public ValidationTimeSliding(I18nProvider i18nProvider, TokenProxy token, Date currentTime, POEExtraction poe, Map<String, XmlBasicBuildingBlocks> bbbs, Context context, ValidationPolicy policy) {
        super(i18nProvider, new XmlVTS());
        this.token = token;
        this.currentTime = currentTime;
        this.bbbs = bbbs;
        this.context = context;
        this.poe = poe;
        this.policy = policy;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.VALIDATION_TIME_SLIDING;
    }

    @Override
    protected void initChain() {
        XmlBasicBuildingBlocks tokenBBB = this.bbbs.get(this.token.getId());
        this.controlTime = this.currentTime;
        List certificateChain = this.token.getCertificateChain();
        if (Utils.isCollectionNotEmpty((Collection)certificateChain)) {
            certificateChain = this.reduceChainUntilFirstTrustAnchor(certificateChain);
            certificateChain = Utils.reverseList(certificateChain);
            ChainItem<XmlVTS> item = null;
            for (CertificateWrapper certificate : certificateChain) {
                XmlSAV revocationSAV;
                if (certificate.isTrusted()) continue;
                SubContext subContext = this.token.getSigningCertificate().getId().equals(certificate.getId()) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
                List<CertificateRevocationWrapper> certificateRevocationData = SubContext.SIGNING_CERT.equals((Object)subContext) ? ValidationProcessUtils.getAcceptableRevocationDataForPSVIfExistOrReturnAll(this.token, certificate, this.bbbs, this.poe) : certificate.getCertificateRevocationData();
                CertificateRevocationWrapper latestCompliantRevocation = null;
                for (CertificateRevocationWrapper revocationData : certificateRevocationData) {
                    XmlBasicBuildingBlocks revocationBBB = this.bbbs.get(revocationData.getId());
                    if (item == null) {
                        this.firstItem = this.revocationBasicValidationAcceptable(revocationBBB);
                        item = this.firstItem;
                    } else {
                        item = item.setNextItem(this.revocationBasicValidationAcceptable(revocationBBB));
                    }
                    if (!ValidationProcessUtils.isAllowedBasicRevocationDataValidation(revocationBBB.getConclusion())) continue;
                    XmlRAC xmlRAC = ValidationProcessUtils.getRevocationAcceptanceCheckerResult(tokenBBB, certificate, (RevocationWrapper)revocationData);
                    item = item.setNextItem(this.revocationDataAcceptable(xmlRAC));
                    if (xmlRAC == null || !this.isValid((XmlConstraintsConclusion)xmlRAC)) continue;
                    item = item.setNextItem(this.revocationIssuedBeforeControlTime((RevocationWrapper)revocationData, this.controlTime));
                    if (revocationData.getProductionDate() == null || !revocationData.getProductionDate().before(this.controlTime)) continue;
                    item = item.setNextItem(this.poeExistsAtOrBeforeControlTime((TokenProxy)certificate, TimestampedObjectType.CERTIFICATE, this.controlTime));
                    item = item.setNextItem(this.poeExistsAtOrBeforeControlTime((TokenProxy)revocationData, TimestampedObjectType.REVOCATION, this.controlTime));
                    if (!this.poe.isPOEExists(certificate.getId(), this.controlTime) || !this.poe.isPOEExists(revocationData.getId(), this.controlTime) || latestCompliantRevocation != null && !revocationData.getProductionDate().after(latestCompliantRevocation.getProductionDate())) continue;
                    latestCompliantRevocation = revocationData;
                }
                if (item == null) {
                    this.firstItem = this.satisfyingRevocationDataExists(certificate, (RevocationWrapper)latestCompliantRevocation, this.controlTime);
                    item = this.firstItem;
                } else {
                    item = item.setNextItem(this.satisfyingRevocationDataExists(certificate, (RevocationWrapper)latestCompliantRevocation, this.controlTime));
                }
                if (latestCompliantRevocation == null) continue;
                if (latestCompliantRevocation.isRevoked()) {
                    Model validationModel = this.policy.getValidationModel();
                    RevocationReason revocationReason = latestCompliantRevocation.getReason();
                    if (Model.SHELL.equals((Object)validationModel) || Model.HYBRID.equals((Object)validationModel) && SubContext.CA_CERTIFICATE.equals((Object)subContext) || RevocationReason.KEY_COMPROMISE.equals((Object)revocationReason) || RevocationReason.UNSPECIFIED.equals((Object)revocationReason)) {
                        this.controlTime = latestCompliantRevocation.getRevocationDate();
                    }
                } else {
                    RevocationFreshnessChecker rfc = new RevocationFreshnessChecker(this.i18nProvider, (RevocationWrapper)latestCompliantRevocation, this.controlTime, this.context, subContext, this.policy);
                    XmlRFC execute = (XmlRFC)rfc.execute();
                    if (execute.getConclusion() != null && Indication.FAILED.equals((Object)execute.getConclusion().getIndication())) {
                        this.controlTime = latestCompliantRevocation.getProductionDate();
                    }
                }
                Date cryptoNotAfterDate = null;
                XmlSAV certificateSAV = this.getCertificateCryptographicAcceptanceResult(certificate, this.controlTime);
                if (!this.isValidConclusion(certificateSAV.getConclusion())) {
                    cryptoNotAfterDate = this.getCryptographicAlgorithmExpirationDateOrNull(certificateSAV);
                }
                if (!this.isValidConclusion((revocationSAV = this.getRevocationCryptographicAcceptanceResult((RevocationWrapper)latestCompliantRevocation, this.controlTime)).getConclusion())) {
                    Date revCryptoNotAfter = this.getCryptographicAlgorithmExpirationDateOrNull(revocationSAV);
                    if (cryptoNotAfterDate == null || revCryptoNotAfter != null && revCryptoNotAfter.before(cryptoNotAfterDate)) {
                        cryptoNotAfterDate = revCryptoNotAfter;
                    }
                }
                if (cryptoNotAfterDate == null || !cryptoNotAfterDate.before(this.controlTime)) continue;
                this.controlTime = cryptoNotAfterDate;
            }
        }
    }

    @Override
    protected void addAdditionalInfo() {
        ((XmlVTS)this.result).setControlTime(this.controlTime);
    }

    private List<CertificateWrapper> reduceChainUntilFirstTrustAnchor(List<CertificateWrapper> originalCertificateChain) {
        ArrayList<CertificateWrapper> result = new ArrayList<CertificateWrapper>();
        for (CertificateWrapper cert : originalCertificateChain) {
            result.add(cert);
            if (!cert.isTrusted()) continue;
            break;
        }
        return result;
    }

    private Date getCryptographicAlgorithmExpirationDateOrNull(XmlSAV sav) {
        if (sav.getCryptographicValidation() != null && sav.getCryptographicValidation().getAlgorithm() != null) {
            return sav.getCryptographicValidation().getNotAfter();
        }
        return null;
    }

    private ChainItem<XmlVTS> revocationBasicValidationAcceptable(XmlBasicBuildingBlocks revocationBBB) {
        return new RevocationDataAcceptableCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, revocationBBB.getId(), revocationBBB.getConclusion(), this.getWarnLevelConstraint());
    }

    private ChainItem<XmlVTS> revocationDataAcceptable(XmlRAC xmlRAC) {
        return new RevocationAcceptanceCheckerResultCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, xmlRAC, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlVTS> revocationIssuedBeforeControlTime(RevocationWrapper revocation, Date controlTime) {
        return new RevocationIssuedBeforeControlTimeCheck(this.i18nProvider, (XmlVTS)this.result, revocation, controlTime, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlVTS> poeExistsAtOrBeforeControlTime(TokenProxy token, TimestampedObjectType objectType, Date controlTime) {
        return new POEExistsAtOrBeforeControlTimeCheck(this.i18nProvider, (XmlVTS)this.result, token, objectType, controlTime, this.poe, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlVTS> satisfyingRevocationDataExists(CertificateWrapper certificateWrapper, RevocationWrapper revocationData, Date controlTime) {
        return new SatisfyingRevocationDataExistsCheck<XmlVTS>(this.i18nProvider, (XmlVTS)this.result, certificateWrapper, revocationData, controlTime, this.getFailLevelConstraint());
    }

    private XmlSAV getCertificateCryptographicAcceptanceResult(CertificateWrapper certificateWrapper, Date controlTime) {
        CertificateAcceptanceValidation cav = new CertificateAcceptanceValidation(this.i18nProvider, controlTime, certificateWrapper, this.policy);
        return (XmlSAV)cav.execute();
    }

    private XmlSAV getRevocationCryptographicAcceptanceResult(RevocationWrapper revocationWrapper, Date controlTime) {
        RevocationAcceptanceValidation rav = new RevocationAcceptanceValidation(this.i18nProvider, controlTime, revocationWrapper, this.policy);
        return (XmlSAV)rav.execute();
    }
}

