/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;

public class POEExistsWithinCertificateValidityRangeCheck
extends ChainItem<XmlPSV> {
    private final CertificateWrapper certificate;
    private final POEExtraction poe;

    public POEExistsWithinCertificateValidityRangeCheck(I18nProvider i18nProvider, XmlPSV result, CertificateWrapper certificate, POEExtraction poe, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
        this.poe = poe;
    }

    @Override
    protected boolean process() {
        return this.certificate != null && this.poe.isPOEExistInRange(this.certificate.getId(), this.certificate.getNotBefore(), this.certificate.getNotAfter());
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.PSV_IPCRIAIDBEDC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.PSV_IPCRIAIDBEDC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.REVOCATION_OUT_OF_BOUNDS_NO_POE;
    }

    @Override
    protected String buildAdditionalInfo() {
        if (this.certificate != null) {
            return this.i18nProvider.getMessage(MessageTag.CERTIFICATE_ID, new Object[]{this.certificate.getId()});
        }
        return null;
    }
}

