/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRAC;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.DigestCryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationAcceptanceCheckerResultCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationIssuerTrustedCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.BestSignatureTimeNotBeforeCertificateIssuanceCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.RevocationDataAcceptableCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.pcv.PastCertificateValidation;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.BestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpirationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.CurrentTimeIndicationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.POEExistsCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.POEExistsWithinCertificateValidityRangeCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.POENotAfterCARevocationTimeCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.PastCertificateValidationAcceptableCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.PastRevocationDataValidationConclusiveCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class PastSignatureValidation
extends Chain<XmlPSV> {
    private final TokenProxy token;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final XmlConclusion currentConclusion;
    private final POEExtraction poe;
    private final Date currentTime;
    private final ValidationPolicy policy;
    private final Context context;

    public PastSignatureValidation(I18nProvider i18nProvider, TokenProxy token, Map<String, XmlBasicBuildingBlocks> bbbs, XmlConclusion currentConclusion, POEExtraction poe, Date currentTime, ValidationPolicy policy, Context context) {
        super(i18nProvider, new XmlPSV());
        this.token = token;
        this.bbbs = bbbs;
        this.currentConclusion = currentConclusion;
        this.poe = poe;
        this.currentTime = currentTime;
        this.policy = policy;
        this.context = context;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.PAST_SIGNATURE_VALIDATION;
    }

    @Override
    protected void initChain() {
        boolean poeExists;
        XmlBasicBuildingBlocks tokenBBB = this.bbbs.get(this.token.getId());
        ChainItem<XmlPSV> item = null;
        CertificateWrapper signingCertificate = this.token.getSigningCertificate();
        List<CertificateRevocationWrapper> signingCertificateRevocations = new ArrayList();
        for (CertificateRevocationWrapper revocationData : signingCertificate.getCertificateRevocationData()) {
            XmlBasicBuildingBlocks revocationBBB = this.bbbs.get(revocationData.getId());
            if (item == null) {
                this.firstItem = this.revocationBasicValidationAcceptable(revocationBBB);
                item = this.firstItem;
            } else {
                item = item.setNextItem(this.revocationBasicValidationAcceptable(revocationBBB));
            }
            if (!ValidationProcessUtils.isAllowedBasicRevocationDataValidation(revocationBBB.getConclusion())) continue;
            XmlRAC xmlRAC = ValidationProcessUtils.getRevocationAcceptanceCheckerResult(tokenBBB, signingCertificate, (RevocationWrapper)revocationData);
            item = item.setNextItem(this.revocationDataAcceptable(xmlRAC));
            CertificateWrapper revocationIssuer = revocationData.getSigningCertificate();
            if (xmlRAC == null || !this.isValid((XmlConstraintsConclusion)xmlRAC) || revocationIssuer == null) continue;
            if (revocationIssuer.isTrusted()) {
                item = item.setNextItem(this.revocationDataIssuerTrusted(revocationIssuer));
                signingCertificateRevocations.add(revocationData);
                continue;
            }
            item = item.setNextItem(this.poeForRevocationDataIssuerExists(revocationIssuer));
            if (!this.poe.isPOEExistInRange(revocationIssuer.getId(), revocationIssuer.getNotBefore(), revocationIssuer.getNotAfter())) continue;
            signingCertificateRevocations.add(revocationData);
        }
        XmlConclusion sigCertRevocationPoeStatus = new XmlConclusion();
        if (Utils.isCollectionNotEmpty(signingCertificateRevocations)) {
            sigCertRevocationPoeStatus.setIndication(Indication.PASSED);
        } else {
            sigCertRevocationPoeStatus.setIndication(Indication.INDETERMINATE);
            sigCertRevocationPoeStatus.setSubIndication(SubIndication.REVOCATION_OUT_OF_BOUNDS_NO_POE);
            signingCertificateRevocations = signingCertificate.getCertificateRevocationData();
        }
        PastCertificateValidation pcv = new PastCertificateValidation(this.i18nProvider, this.token, this.bbbs, this.poe, this.currentTime, this.policy, this.context);
        XmlPCV pcvResult = (XmlPCV)pcv.execute();
        tokenBBB.setPCV(pcvResult);
        if (item == null) {
            this.firstItem = this.pastCertificateValidationAcceptableCheck(pcvResult);
            item = this.firstItem;
        } else {
            item = item.setNextItem(this.pastCertificateValidationAcceptableCheck(pcvResult));
        }
        Date controlTime = pcvResult.getControlTime();
        ((XmlPSV)this.result).setControlTime(controlTime);
        boolean bl = poeExists = controlTime != null && this.poe.isPOEExists(this.token.getId(), controlTime);
        if (poeExists) {
            item = item.setNextItem(this.poeExist());
        }
        if (!poeExists || !Indication.INDETERMINATE.equals((Object)this.currentConclusion.getIndication()) || !SubIndication.REVOKED_NO_POE.equals((Object)this.currentConclusion.getSubIndication()) && !SubIndication.REVOCATION_OUT_OF_BOUNDS_NO_POE.equals((Object)this.currentConclusion.getSubIndication())) {
            if (poeExists && Indication.INDETERMINATE.equals((Object)this.currentConclusion.getIndication()) && SubIndication.REVOKED_CA_NO_POE.equals((Object)this.currentConclusion.getSubIndication())) {
                CertificateRevocationWrapper latestCARevocationData;
                CertificateWrapper caCertificate = signingCertificate.getSigningCertificate();
                CertificateRevocationWrapper certificateRevocationWrapper = latestCARevocationData = caCertificate == null ? null : ValidationProcessUtils.getLatestAcceptableRevocationData(this.token, caCertificate, caCertificate.getCertificateRevocationData(), this.currentTime, this.bbbs, this.poe);
                if (latestCARevocationData != null) {
                    item = item.setNextItem(this.poeExistNotAfterCARevocationTimeCheck(signingCertificateRevocations, latestCARevocationData.getRevocationDate()));
                }
            } else if (poeExists && Indication.INDETERMINATE.equals((Object)this.currentConclusion.getIndication()) && (SubIndication.OUT_OF_BOUNDS_NO_POE.equals((Object)this.currentConclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals((Object)this.currentConclusion.getSubIndication()))) {
                Date bestSignatureTime = this.poe.getLowestPOETime(this.token.getId());
                item = item.setNextItem(this.bestSignatureTimeNotBeforeCertificateIssuance(bestSignatureTime, signingCertificate));
                item = item.setNextItem(this.bestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpiration(bestSignatureTime, signingCertificate, this.currentConclusion.getSubIndication()));
            } else if (Indication.INDETERMINATE.equals((Object)this.currentConclusion.getIndication()) && SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals((Object)this.currentConclusion.getSubIndication())) {
                CryptographicConstraint cryptographicConstraint = this.policy.getSignatureCryptographicConstraint(this.context);
                item = item.setNextItem(this.tokenUsedAlgorithmsAreSecureAtPoeTime(this.token, ValidationProcessUtils.getCryptoPosition(this.context), cryptographicConstraint));
                if (Utils.isCollectionNotEmpty((Collection)this.token.getDigestMatchers())) {
                    Date tokenPoeTime = this.getLowestPoeTime(this.token);
                    for (XmlDigestMatcher digestMatcher : this.token.getDigestMatchers()) {
                        item = item.setNextItem(this.digestMatcherIsSecureAtPoeTime(digestMatcher, tokenPoeTime, cryptographicConstraint));
                    }
                }
                item = this.certificateChainReliableAtPoeTime(item, signingCertificateRevocations, this.context);
            } else {
                item = item.setNextItem(this.currentTimeIndicationCheck());
            }
        }
        item = item.setNextItem(this.pastRevocationDataValidationConclusive(sigCertRevocationPoeStatus));
    }

    private ChainItem<XmlPSV> revocationBasicValidationAcceptable(XmlBasicBuildingBlocks revocationBBB) {
        return new RevocationDataAcceptableCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, revocationBBB.getId(), revocationBBB.getConclusion(), this.getWarnLevelConstraint());
    }

    private ChainItem<XmlPSV> revocationDataAcceptable(XmlRAC xmlRAC) {
        return new RevocationAcceptanceCheckerResultCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, xmlRAC, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlPSV> revocationDataIssuerTrusted(CertificateWrapper revocationIssuer) {
        return new RevocationIssuerTrustedCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, revocationIssuer, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlPSV> poeForRevocationDataIssuerExists(CertificateWrapper revocationIssuer) {
        return new POEExistsWithinCertificateValidityRangeCheck(this.i18nProvider, (XmlPSV)this.result, revocationIssuer, this.poe, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlPSV> currentTimeIndicationCheck() {
        return new CurrentTimeIndicationCheck(this.i18nProvider, (XmlPSV)this.result, this.currentConclusion.getIndication(), this.currentConclusion.getSubIndication(), this.currentConclusion.getErrors(), this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> pastCertificateValidationAcceptableCheck(XmlPCV pcvResult) {
        return new PastCertificateValidationAcceptableCheck(this.i18nProvider, (XmlPSV)this.result, pcvResult, this.token.getId(), this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> poeExist() {
        return new POEExistsCheck(this.i18nProvider, (XmlPSV)this.result, this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> poeExistNotAfterCARevocationTimeCheck(Collection<CertificateRevocationWrapper> certificateRevocations, Date caRevocationTime) {
        return new POENotAfterCARevocationTimeCheck<CertificateRevocationWrapper>(this.i18nProvider, (XmlPSV)this.result, certificateRevocations, caRevocationTime, this.poe, this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> pastRevocationDataValidationConclusive(XmlConclusion currentConclusion) {
        return new PastRevocationDataValidationConclusiveCheck(this.i18nProvider, (XmlPSV)this.result, currentConclusion, this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> bestSignatureTimeNotBeforeCertificateIssuance(Date bestSignatureTime, CertificateWrapper signingCertificate) {
        return new BestSignatureTimeNotBeforeCertificateIssuanceCheck<XmlPSV>(this.i18nProvider, (XmlPSV)this.result, bestSignatureTime, signingCertificate, this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> bestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpiration(Date bestSignatureTime, CertificateWrapper signingCertificate, SubIndication currentTimeSubIndication) {
        return new BestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpirationCheck(this.i18nProvider, (XmlPSV)this.result, bestSignatureTime, signingCertificate, currentTimeSubIndication, this.getFailLevelConstraint());
    }

    private CryptographicCheck<XmlPSV> tokenUsedAlgorithmsAreSecureAtPoeTime(TokenProxy currentToken, MessageTag position, CryptographicConstraint constraint) {
        return new CryptographicCheck<XmlPSV>(this.i18nProvider, (XmlPSV)this.result, currentToken, position, this.getLowestPoeTime(this.token), constraint);
    }

    private ChainItem<XmlPSV> digestMatcherIsSecureAtPoeTime(XmlDigestMatcher digestMatcher, Date validationDate, CryptographicConstraint constraint) {
        MessageTag position = ValidationProcessUtils.getDigestMatcherCryptoPosition(digestMatcher);
        return new DigestCryptographicCheck<XmlPSV>(this.i18nProvider, digestMatcher.getDigestMethod(), (XmlPSV)this.result, validationDate, position, constraint);
    }

    private ChainItem<XmlPSV> certificateChainReliableAtPoeTime(ChainItem<XmlPSV> item, List<CertificateRevocationWrapper> signingCertificateRevocations, Context context) {
        return this.certificateChainReliableAtPoeTime(item, this.token.getCertificateChain(), signingCertificateRevocations, context, new ArrayList<String>());
    }

    private ChainItem<XmlPSV> certificateChainReliableAtPoeTime(ChainItem<XmlPSV> item, List<CertificateWrapper> certificateChain, List<CertificateRevocationWrapper> signingCertificateRevocations, Context context, List<String> checkedTokens) {
        for (CertificateWrapper certificate : certificateChain) {
            if (certificate.isTrusted()) break;
            if (checkedTokens.contains(certificate.getId())) continue;
            checkedTokens.add(certificate.getId());
            SubContext subContext = this.token.getSigningCertificate().getId().equals(certificate.getId()) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
            List revocationData = SubContext.SIGNING_CERT.equals((Object)subContext) ? signingCertificateRevocations : certificate.getCertificateRevocationData();
            item = item.setNextItem(this.tokenUsedAlgorithmsAreSecureAtPoeTime((TokenProxy)certificate, ValidationProcessUtils.getCertificateChainCryptoPosition(context), this.policy.getCertificateCryptographicConstraint(context, subContext)));
            CertificateRevocationWrapper latestAcceptableRevocation = ValidationProcessUtils.getLatestAcceptableRevocationData(this.token, certificate, revocationData, this.currentTime, this.bbbs, this.poe);
            if (latestAcceptableRevocation == null || checkedTokens.contains(latestAcceptableRevocation.getId())) continue;
            checkedTokens.add(latestAcceptableRevocation.getId());
            item = item.setNextItem(this.tokenUsedAlgorithmsAreSecureAtPoeTime((TokenProxy)latestAcceptableRevocation, ValidationProcessUtils.getCertificateChainCryptoPosition(Context.REVOCATION), this.policy.getSignatureCryptographicConstraint(Context.REVOCATION)));
            item = this.certificateChainReliableAtPoeTime(item, latestAcceptableRevocation.getCertificateChain(), signingCertificateRevocations, Context.REVOCATION, checkedTokens);
        }
        return item;
    }

    private Date getLowestPoeTime(TokenProxy token) {
        return this.poe.getLowestPOETime(token.getId());
    }
}

