/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSignature;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalData;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessLongTermData;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessTimestamp;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.MessageImprintDigestAlgorithmValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.SignatureAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SignatureAcceptanceValidationResultCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.TimestampMessageImprintCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.POE;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.AcceptableBasicTimestampValidationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.LongTermValidationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.MessageImprintDigestAlgorithmValidationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.PastSignatureValidationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.PastTimestampValidationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.PastSignatureValidation;
import eu.europa.esig.dss.validation.process.vpftsp.checks.BasicTimestampValidationCheck;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ValidationProcessForSignaturesWithArchivalData
extends Chain<XmlValidationProcessArchivalData> {
    private final XmlValidationProcessLongTermData validationProcessLongTermData;
    private final DiagnosticData diagnosticData;
    private final SignatureWrapper signature;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final List<XmlTimestamp> xmlTimestamps;
    private final ValidationPolicy policy;
    private final Date currentTime;
    private final POEExtraction poe = new POEExtraction();

    public ValidationProcessForSignaturesWithArchivalData(I18nProvider i18nProvider, XmlSignature signatureAnalysis, SignatureWrapper signature, DiagnosticData diagnosticData, Map<String, XmlBasicBuildingBlocks> bbbs, ValidationPolicy policy, Date currentTime) {
        super(i18nProvider, new XmlValidationProcessArchivalData());
        this.validationProcessLongTermData = signatureAnalysis.getValidationProcessLongTermData();
        this.xmlTimestamps = signatureAnalysis.getTimestamps();
        this.signature = signature;
        this.diagnosticData = diagnosticData;
        this.bbbs = bbbs;
        this.policy = policy;
        this.currentTime = currentTime;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.VPFSWATSP;
    }

    @Override
    protected void initChain() {
        Context currentContext = Context.SIGNATURE;
        if (this.signature.isCounterSignature()) {
            currentContext = Context.COUNTER_SIGNATURE;
        }
        this.poe.init(this.diagnosticData, this.currentTime);
        ChainItem<XmlValidationProcessArchivalData> item = this.firstItem = this.longTermValidation();
        ((XmlValidationProcessArchivalData)this.result).setProofOfExistence(this.validationProcessLongTermData.getProofOfExistence());
        if (!ValidationProcessUtils.isAllowedValidationWithLongTermData(this.validationProcessLongTermData.getConclusion())) {
            return;
        }
        XmlProofOfExistence signatureProofOfExistence = this.validationProcessLongTermData.getProofOfExistence();
        this.poe.addSignaturePOE(this.signature, this.toPOE(signatureProofOfExistence));
        List timestampsList = this.signature.getTimestampList();
        if (Utils.isCollectionNotEmpty((Collection)timestampsList)) {
            timestampsList.sort(Comparator.comparing(TimestampWrapper::getProductionTime).reversed());
            XmlConclusion latestConclusion = null;
            for (TimestampWrapper newestTimestamp : timestampsList) {
                XmlBasicBuildingBlocks bbbTsp = this.bbbs.get(newestTimestamp.getId());
                XmlValidationProcessTimestamp timestampValidation = this.getTimestampValidation(newestTimestamp);
                if (bbbTsp != null && timestampValidation != null) {
                    latestConclusion = timestampValidation.getConclusion();
                    item = item.setNextItem(this.timestampBasicSignatureValidationAcceptable(newestTimestamp, timestampValidation));
                    if (!ValidationProcessUtils.isAllowedBasicTimestampValidation(latestConclusion)) continue;
                    item = item.setNextItem(this.timestampBasicSignatureValidationConclusive(newestTimestamp, timestampValidation));
                    Date lowestPOETime = this.poe.getLowestPOETime(newestTimestamp.getId());
                    MessageImprintDigestAlgorithmValidation messageImprintValidation = this.timestampDigestAlgorithmValidation(newestTimestamp, lowestPOETime);
                    XmlSAV davResult = (XmlSAV)messageImprintValidation.execute();
                    if (this.isValid((XmlConstraintsConclusion)timestampValidation)) {
                        item = item.setNextItem(this.messageImprintDigestAlgorithm(newestTimestamp, davResult, lowestPOETime));
                        if (!this.isValid((XmlConstraintsConclusion)davResult)) continue;
                        item = item.setNextItem(this.timestampMessageImprint(newestTimestamp));
                        this.poe.extractPOE(newestTimestamp);
                        continue;
                    }
                    PastSignatureValidation psv = new PastSignatureValidation(this.i18nProvider, (TokenProxy)newestTimestamp, this.bbbs, timestampValidation.getConclusion(), this.poe, this.currentTime, this.policy, Context.TIMESTAMP);
                    XmlPSV psvResult = (XmlPSV)psv.execute();
                    bbbTsp.setPSV(psvResult);
                    this.enrichBBBWithPSVConclusion(bbbTsp, psvResult);
                    item = item.setNextItem(this.pastTimestampValidation(newestTimestamp, psvResult));
                    if (!this.isValid((XmlConstraintsConclusion)psvResult)) continue;
                    item = item.setNextItem(this.messageImprintDigestAlgorithm(newestTimestamp, davResult, lowestPOETime));
                    if (!this.isValid((XmlConstraintsConclusion)davResult)) continue;
                    item = item.setNextItem(this.timestampMessageImprint(newestTimestamp));
                    this.poe.extractPOE(newestTimestamp);
                    continue;
                }
                ((XmlValidationProcessArchivalData)this.result).setConclusion(latestConclusion);
                break;
            }
        }
        POE bestSignatureTime = this.poe.getLowestPOE(this.signature.getId());
        ((XmlValidationProcessArchivalData)this.result).setProofOfExistence(this.toXmlProofOfExistence(bestSignatureTime));
        if (this.isValid((XmlConstraintsConclusion)this.validationProcessLongTermData)) {
            return;
        }
        XmlBasicBuildingBlocks sigBBB = this.bbbs.get(this.signature.getId());
        PastSignatureValidation psv = new PastSignatureValidation(this.i18nProvider, (TokenProxy)this.signature, this.bbbs, this.validationProcessLongTermData.getConclusion(), this.poe, this.currentTime, this.policy, currentContext);
        XmlPSV psvResult = (XmlPSV)psv.execute();
        sigBBB.setPSV(psvResult);
        this.enrichBBBWithPSVConclusion(sigBBB, psvResult);
        item = item.setNextItem(this.pastSignatureValidation(psvResult));
        item = item.setNextItem(this.signatureIsAcceptable(bestSignatureTime.getTime(), currentContext));
    }

    private ChainItem<XmlValidationProcessArchivalData> pastSignatureValidation(XmlPSV xmlPSV) {
        return new PastSignatureValidationCheck(this.i18nProvider, (XmlValidationProcessArchivalData)this.result, this.signature, xmlPSV, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationProcessArchivalData> longTermValidation() {
        return new LongTermValidationCheck(this.i18nProvider, (XmlValidationProcessArchivalData)this.result, (XmlConstraintsConclusion)this.validationProcessLongTermData, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationProcessArchivalData> timestampBasicSignatureValidationAcceptable(TimestampWrapper timestampWrapper, XmlValidationProcessTimestamp timestampValidationResult) {
        return new AcceptableBasicTimestampValidationCheck(this.i18nProvider, (XmlValidationProcessArchivalData)this.result, timestampWrapper, (XmlConstraintsConclusion)timestampValidationResult, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationProcessArchivalData> timestampBasicSignatureValidationConclusive(TimestampWrapper timestampWrapper, XmlValidationProcessTimestamp timestampValidationResult) {
        return new BasicTimestampValidationCheck<XmlValidationProcessArchivalData>(this.i18nProvider, (XmlValidationProcessArchivalData)this.result, timestampWrapper, timestampValidationResult, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationProcessArchivalData> pastTimestampValidation(TimestampWrapper timestamp, XmlPSV xmlPSV) {
        return new PastTimestampValidationCheck(this.i18nProvider, (XmlValidationProcessArchivalData)this.result, timestamp, xmlPSV, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationProcessArchivalData> messageImprintDigestAlgorithm(TimestampWrapper timestampWrapper, XmlSAV davResult, Date poeTime) {
        return new MessageImprintDigestAlgorithmValidationCheck(this.i18nProvider, (XmlValidationProcessArchivalData)this.result, timestampWrapper, davResult, poeTime, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationProcessArchivalData> timestampMessageImprint(TimestampWrapper timestampWrapper) {
        return new TimestampMessageImprintCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, timestampWrapper, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationProcessArchivalData> signatureIsAcceptable(Date bestSignatureTime, Context context) {
        SignatureAcceptanceValidation sav = new SignatureAcceptanceValidation(this.i18nProvider, this.diagnosticData, bestSignatureTime, this.signature, context, this.policy);
        XmlSAV savResult = (XmlSAV)sav.execute();
        return new SignatureAcceptanceValidationResultCheck<XmlValidationProcessArchivalData>(this.i18nProvider, (XmlValidationProcessArchivalData)this.result, savResult, this.getFailLevelConstraint());
    }

    private void enrichBBBWithPSVConclusion(XmlBasicBuildingBlocks bbb, XmlPSV psv) {
        XmlConclusion bbbConclusion = bbb.getConclusion();
        XmlConclusion psvConclusion = psv.getConclusion();
        bbbConclusion.setIndication(psvConclusion.getIndication());
        bbbConclusion.setSubIndication(psvConclusion.getSubIndication());
        bbbConclusion.getErrors().addAll(psvConclusion.getErrors());
        bbbConclusion.getWarnings().addAll(psvConclusion.getWarnings());
        bbbConclusion.getInfos().addAll(psvConclusion.getInfos());
    }

    private XmlProofOfExistence toXmlProofOfExistence(POE poe) {
        XmlProofOfExistence xmlPoe = new XmlProofOfExistence();
        xmlPoe.setTime(poe.getTime());
        xmlPoe.setTimestampId(poe.getTimestampId());
        return xmlPoe;
    }

    private POE toPOE(XmlProofOfExistence xmlProofOfExistence) {
        String timestampId = xmlProofOfExistence.getTimestampId();
        if (timestampId != null) {
            for (TimestampWrapper timestamp : this.diagnosticData.getTimestampList()) {
                if (!timestampId.equals(timestamp.getId())) continue;
                return new POE(timestamp);
            }
        }
        return new POE(xmlProofOfExistence.getTime());
    }

    private XmlValidationProcessTimestamp getTimestampValidation(TimestampWrapper newestTimestamp) {
        for (XmlTimestamp xmlTimestamp : this.xmlTimestamps) {
            if (!Utils.areStringsEqual((String)xmlTimestamp.getId(), (String)newestTimestamp.getId())) continue;
            return xmlTimestamp.getValidationProcessTimestamp();
        }
        return null;
    }

    private MessageImprintDigestAlgorithmValidation timestampDigestAlgorithmValidation(TimestampWrapper newestTimestamp, Date poeTime) {
        CryptographicConstraint cryptographicConstraint = this.policy.getSignatureCryptographicConstraint(Context.TIMESTAMP);
        return new MessageImprintDigestAlgorithmValidation(this.i18nProvider, poeTime, newestTimestamp.getMessageImprint().getDigestMethod(), cryptographicConstraint);
    }

    @Override
    protected void collectMessages(XmlConclusion conclusion, XmlConstraint constraint) {
        if (!XmlBlockType.TST_BBB.equals((Object)constraint.getBlockType()) && !XmlBlockType.TST_PSV.equals((Object)constraint.getBlockType())) {
            super.collectMessages(conclusion, constraint);
        }
    }

    @Override
    protected void collectAdditionalMessages(XmlConclusion conclusion) {
        if (!ValidationProcessUtils.isAllowedValidationWithLongTermData(this.validationProcessLongTermData.getConclusion())) {
            conclusion.getWarnings().addAll(this.validationProcessLongTermData.getConclusion().getWarnings());
            conclusion.getInfos().addAll(this.validationProcessLongTermData.getConclusion().getInfos());
        }
    }
}

