/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfltvd.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;

public class RevocationDataAcceptableCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final String revocationId;
    private final XmlConclusion xmlConclusion;

    public RevocationDataAcceptableCheck(I18nProvider i18nProvider, T result, String revocationId, XmlConclusion xmlConclusion, LevelConstraint constraint) {
        super(i18nProvider, result, constraint, revocationId);
        this.revocationId = revocationId;
        this.xmlConclusion = xmlConclusion;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.REV_BBB;
    }

    @Override
    protected boolean process() {
        return this.xmlConclusion != null && ValidationProcessUtils.isAllowedBasicRevocationDataValidation(this.xmlConclusion);
    }

    @Override
    protected String buildAdditionalInfo() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_ID, new Object[]{this.revocationId});
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.xmlConclusion.getIndication();
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.xmlConclusion.getSubIndication();
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ADEST_RORPIIC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.ADEST_RORPIIC_ANS;
    }
}

