/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfltvd.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public class BestSignatureTimeNotBeforeCertificateIssuanceCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final Date bestSignatureTime;
    private final CertificateWrapper signingCertificate;
    private final Indication currentIndication;
    private final SubIndication currentSubIndication;

    public BestSignatureTimeNotBeforeCertificateIssuanceCheck(I18nProvider i18nProvider, T result, Date bestSignatureTime, CertificateWrapper signingCertificate, LevelConstraint constraint) {
        this(i18nProvider, result, bestSignatureTime, signingCertificate, null, null, constraint);
    }

    public BestSignatureTimeNotBeforeCertificateIssuanceCheck(I18nProvider i18nProvider, T result, Date bestSignatureTime, CertificateWrapper signingCertificate, Indication currentIndication, SubIndication currentSubIndication, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.bestSignatureTime = bestSignatureTime;
        this.signingCertificate = signingCertificate;
        this.currentIndication = currentIndication;
        this.currentSubIndication = currentSubIndication;
    }

    @Override
    protected boolean process() {
        return !this.bestSignatureTime.before(this.signingCertificate.getNotBefore());
    }

    @Override
    protected String buildAdditionalInfo() {
        String bestSignatureTimeStr = this.bestSignatureTime == null ? " ? " : ValidationProcessUtils.getFormattedDate(this.bestSignatureTime);
        String certNotBefore = this.signingCertificate.getNotBefore() == null ? " ? " : ValidationProcessUtils.getFormattedDate(this.signingCertificate.getNotBefore());
        return this.i18nProvider.getMessage(MessageTag.BEST_SIGNATURE_TIME_CERT_NOT_BEFORE, new Object[]{bestSignatureTimeStr, certNotBefore});
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.TSV_IBSTAIDOSC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.TSV_IBSTAIDOSC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.NOT_YET_VALID;
    }

    @Override
    protected Indication getSuccessIndication() {
        return this.currentIndication;
    }

    @Override
    protected SubIndication getSuccessSubIndication() {
        return this.currentSubIndication;
    }
}

