/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfbs.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicAlgorithm;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicValidation;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;

public class TimestampGenerationTimeNotAfterCryptographicConstraintsExpirationCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final TimestampWrapper contentTimestamp;
    private final XmlCryptographicValidation cryptographicValidation;

    public TimestampGenerationTimeNotAfterCryptographicConstraintsExpirationCheck(I18nProvider i18nProvider, T result, TimestampWrapper contentTimestamp, XmlCryptographicValidation cryptographicValidation, LevelConstraint constraint) {
        super(i18nProvider, result, constraint, contentTimestamp.getId());
        this.contentTimestamp = contentTimestamp;
        this.cryptographicValidation = cryptographicValidation;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.CNT_TST_BBB;
    }

    @Override
    protected boolean process() {
        return this.contentTimestamp.getProductionTime() != null && !this.contentTimestamp.getProductionTime().after(this.cryptographicValidation.getNotAfter());
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.CRYPTO_CONSTRAINTS_FAILURE;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BSV_ICTGTNACCET;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BSV_ICTGTNACCET_ANS;
    }

    @Override
    protected String buildAdditionalInfo() {
        String tstGenerationTime = this.contentTimestamp.getProductionTime() == null ? " ? " : ValidationProcessUtils.getFormattedDate(this.contentTimestamp.getProductionTime());
        String cryptoConstraintsExpiration = this.cryptographicValidation.getNotAfter() == null ? " ? " : ValidationProcessUtils.getFormattedDate(this.cryptographicValidation.getNotAfter());
        String algorithmName = "?";
        XmlCryptographicAlgorithm algorithm = this.cryptographicValidation.getAlgorithm();
        if (algorithm != null) {
            algorithmName = algorithm.getName();
            if (algorithm.getKeyLength() != null) {
                algorithmName = algorithmName + " with keyLength '" + algorithm.getKeyLength() + "'";
            }
        }
        return this.i18nProvider.getMessage(MessageTag.TIMESTAMP_AND_CRYPTO_CONSTRAINTS_EXPIRATION, new Object[]{this.contentTimestamp.getId(), tstGenerationTime, algorithmName, cryptoConstraintsExpiration});
    }
}

