/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfbs;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicValidation;
import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlISC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlVCI;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.vpfbs.checks.BasicValidationProcessCheck;
import eu.europa.esig.dss.validation.process.vpfbs.checks.ContentTimestampsCheck;
import eu.europa.esig.dss.validation.process.vpfbs.checks.CryptographicVerificationResultCheck;
import eu.europa.esig.dss.validation.process.vpfbs.checks.FormatCheckingResultCheck;
import eu.europa.esig.dss.validation.process.vpfbs.checks.IdentificationOfSigningCertificateResultCheck;
import eu.europa.esig.dss.validation.process.vpfbs.checks.SignatureAcceptanceValidationResultCheck;
import eu.europa.esig.dss.validation.process.vpfbs.checks.SigningCertificateNotRevokedCheck;
import eu.europa.esig.dss.validation.process.vpfbs.checks.TimestampGenerationTimeNotAfterCertificateExpirationCheck;
import eu.europa.esig.dss.validation.process.vpfbs.checks.TimestampGenerationTimeNotAfterCryptographicConstraintsExpirationCheck;
import eu.europa.esig.dss.validation.process.vpfbs.checks.TimestampGenerationTimeNotAfterRevocationTimeCheck;
import eu.europa.esig.dss.validation.process.vpfbs.checks.ValidationContextInitializationResultCheck;
import eu.europa.esig.dss.validation.process.vpfbs.checks.ValidationTimeAtCertificateValidityRangeCheck;
import eu.europa.esig.dss.validation.process.vpfbs.checks.X509CertificateValidationResultCheck;
import eu.europa.esig.dss.validation.process.vpftsp.checks.BasicTimestampValidationCheck;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class AbstractBasicValidationProcess<T extends XmlConstraintsConclusion>
extends Chain<T> {
    protected final DiagnosticData diagnosticData;
    protected final TokenProxy token;
    protected final Map<String, XmlBasicBuildingBlocks> bbbs;

    public AbstractBasicValidationProcess(I18nProvider i18nProvider, T result, DiagnosticData diagnosticData, TokenProxy token, Map<String, XmlBasicBuildingBlocks> bbbs) {
        super(i18nProvider, result);
        this.diagnosticData = diagnosticData;
        this.token = token;
        this.bbbs = bbbs;
    }

    @Override
    protected void initChain() {
        XmlSAV xmlSAV;
        XmlCV xmlCV;
        XmlBasicBuildingBlocks tokenBBBs = this.bbbs.get(this.token.getId());
        if (tokenBBBs == null) {
            throw new IllegalStateException(String.format("Missing Basic Building Blocks result for token with Id '%s'", this.token.getId()));
        }
        ChainItem<T> item = this.firstItem;
        XmlFC xmlFC = tokenBBBs.getFC();
        if (xmlFC != null) {
            item = this.firstItem = this.formatChecking(xmlFC);
        }
        XmlISC xmlISC = tokenBBBs.getISC();
        if (this.firstItem == null) {
            this.firstItem = this.identificationOfSigningCertificate(xmlISC);
            item = this.firstItem;
        } else {
            item = item.setNextItem(this.identificationOfSigningCertificate(xmlISC));
        }
        XmlVCI xmlVCI = tokenBBBs.getVCI();
        if (xmlVCI != null) {
            item = item.setNextItem(this.validationContextInitialization(xmlVCI));
        }
        List<TimestampWrapper> contentTimestamps = this.getContentTimestamps();
        XmlConclusion x509ValidationStatus = new XmlConclusion();
        XmlXCV xmlXCV = tokenBBBs.getXCV();
        if (xmlXCV != null) {
            item = item.setNextItem(this.x509CertificateValidation(xmlXCV));
            if (this.isValid((XmlConstraintsConclusion)xmlXCV)) {
                x509ValidationStatus.setIndication(Indication.PASSED);
            } else {
                XmlValidationProcessTimestamp timestampValidation;
                x509ValidationStatus.setIndication(xmlXCV.getConclusion().getIndication());
                x509ValidationStatus.setSubIndication(xmlXCV.getConclusion().getSubIndication());
                item = item.setNextItem(this.signingCertificateNotRevoked(xmlXCV));
                if (Indication.INDETERMINATE.equals((Object)xmlXCV.getConclusion().getIndication()) && SubIndication.REVOKED_NO_POE.equals((Object)xmlXCV.getConclusion().getSubIndication()) && Utils.isCollectionNotEmpty(contentTimestamps)) {
                    Date revocationTime = this.getRevocationTimeForSigningCertificate();
                    item = item.setNextItem(this.contentTimestampsPresent(contentTimestamps));
                    for (TimestampWrapper timestampWrapper : contentTimestamps) {
                        timestampValidation = this.getTimestampValidation(timestampWrapper.getId());
                        if (timestampValidation == null) continue;
                        item = item.setNextItem(this.timestampBasicValidation(timestampWrapper, timestampValidation));
                        if (!this.isValid((XmlConstraintsConclusion)timestampValidation)) continue;
                        item = item.setNextItem(this.timestampNotAfterRevocationTime(timestampWrapper, revocationTime));
                        if (!timestampWrapper.getProductionTime().after(revocationTime)) continue;
                        x509ValidationStatus.setIndication(Indication.FAILED);
                        x509ValidationStatus.setSubIndication(SubIndication.REVOKED);
                        break;
                    }
                }
                item = item.setNextItem(this.validationTimeAtValidityRange(xmlXCV));
                if (Indication.INDETERMINATE.equals((Object)xmlXCV.getConclusion().getIndication()) && (SubIndication.OUT_OF_BOUNDS_NO_POE.equals((Object)xmlXCV.getConclusion().getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals((Object)xmlXCV.getConclusion().getSubIndication())) && Utils.isCollectionNotEmpty(contentTimestamps)) {
                    Date certificateNotAfter = this.token.getSigningCertificate().getNotAfter();
                    item = item.setNextItem(this.contentTimestampsPresent(contentTimestamps));
                    for (TimestampWrapper timestampWrapper : contentTimestamps) {
                        timestampValidation = this.getTimestampValidation(timestampWrapper.getId());
                        if (timestampValidation == null) continue;
                        item = item.setNextItem(this.timestampBasicValidation(timestampWrapper, timestampValidation));
                        if (!this.isValid((XmlConstraintsConclusion)timestampValidation)) continue;
                        item = item.setNextItem(this.timestampNotAfterSigningCertificateNotAfterTime(timestampWrapper, certificateNotAfter));
                        if (!timestampWrapper.getProductionTime().after(certificateNotAfter)) continue;
                        x509ValidationStatus.setIndication(Indication.FAILED);
                        x509ValidationStatus.setSubIndication(SubIndication.EXPIRED);
                        break;
                    }
                }
            }
        }
        if ((xmlCV = tokenBBBs.getCV()) != null) {
            item = item.setNextItem(this.cryptographicVerification(xmlCV));
            if (this.isValid((XmlConstraintsConclusion)xmlCV) && (Indication.INDETERMINATE.equals((Object)x509ValidationStatus.getIndication()) || Indication.FAILED.equals((Object)x509ValidationStatus.getIndication()))) {
                item = item.setNextItem(this.basicValidationProcess(x509ValidationStatus));
            }
        }
        if ((xmlSAV = tokenBBBs.getSAV()) != null) {
            XmlCryptographicValidation cryptographicValidation = xmlSAV.getCryptographicValidation();
            item = item.setNextItem(this.signatureAcceptanceValidation(xmlSAV));
            if (!Indication.PASSED.equals((Object)xmlSAV.getConclusion().getIndication()) && Indication.INDETERMINATE.equals((Object)xmlSAV.getConclusion().getIndication()) && SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals((Object)xmlSAV.getConclusion().getSubIndication()) && this.isSignatureValueConcernedByFailure(cryptographicValidation) && Utils.isCollectionNotEmpty(contentTimestamps)) {
                item = item.setNextItem(this.contentTimestampsPresent(contentTimestamps));
                for (TimestampWrapper timestampWrapper : contentTimestamps) {
                    XmlValidationProcessTimestamp timestampValidation = this.getTimestampValidation(timestampWrapper.getId());
                    if (timestampValidation == null) continue;
                    item = item.setNextItem(this.timestampBasicValidation(timestampWrapper, timestampValidation));
                    if (!this.isValid((XmlConstraintsConclusion)timestampValidation)) continue;
                    item = item.setNextItem(this.timestampNotAfterCryptographicConstraintsExpiration(timestampWrapper, cryptographicValidation));
                }
            }
            if (!this.isValidConclusion(xmlSAV.getConclusion())) {
                item = item.setNextItem(this.basicValidationProcess(xmlSAV.getConclusion()));
            }
        }
    }

    private ChainItem<T> formatChecking(XmlFC xmlFC) {
        return new FormatCheckingResultCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, xmlFC, this.token, this.getFailLevelConstraint());
    }

    private ChainItem<T> identificationOfSigningCertificate(XmlISC xmlISC) {
        return new IdentificationOfSigningCertificateResultCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, xmlISC, this.token, this.getFailLevelConstraint());
    }

    private ChainItem<T> validationContextInitialization(XmlVCI xmlVCI) {
        return new ValidationContextInitializationResultCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, xmlVCI, this.token, this.getFailLevelConstraint());
    }

    private ChainItem<T> x509CertificateValidation(XmlXCV xmlXCV) {
        return new X509CertificateValidationResultCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, xmlXCV, this.token, this.getWarnLevelConstraint());
    }

    private ChainItem<T> signingCertificateNotRevoked(XmlXCV xmlXCV) {
        return new SigningCertificateNotRevokedCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, xmlXCV, this.token, this.getWarnLevelConstraint());
    }

    private ChainItem<T> validationTimeAtValidityRange(XmlXCV xmlXCV) {
        return new ValidationTimeAtCertificateValidityRangeCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, xmlXCV, this.token, this.getWarnLevelConstraint());
    }

    private ChainItem<T> contentTimestampsPresent(List<TimestampWrapper> contentTimestamps) {
        return new ContentTimestampsCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, contentTimestamps, this.getWarnLevelConstraint());
    }

    private ChainItem<T> timestampBasicValidation(TimestampWrapper timestamp, XmlValidationProcessTimestamp timestampValidation) {
        return new BasicTimestampValidationCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, timestamp, timestampValidation, this.getWarnLevelConstraint());
    }

    private ChainItem<T> timestampNotAfterRevocationTime(TimestampWrapper timestamp, Date revocationTime) {
        return new TimestampGenerationTimeNotAfterRevocationTimeCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, timestamp, revocationTime, this.getWarnLevelConstraint());
    }

    private ChainItem<T> timestampNotAfterSigningCertificateNotAfterTime(TimestampWrapper timestamp, Date revocationTime) {
        return new TimestampGenerationTimeNotAfterCertificateExpirationCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, timestamp, revocationTime, this.getWarnLevelConstraint());
    }

    private ChainItem<T> cryptographicVerification(XmlCV xmlCV) {
        return new CryptographicVerificationResultCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, xmlCV, this.token, this.getFailLevelConstraint());
    }

    private ChainItem<T> signatureAcceptanceValidation(XmlSAV xmlSAV) {
        return new SignatureAcceptanceValidationResultCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, xmlSAV, this.token, this.getWarnLevelConstraint());
    }

    private ChainItem<T> timestampNotAfterCryptographicConstraintsExpiration(TimestampWrapper timestamp, XmlCryptographicValidation cryptographicValidation) {
        return new TimestampGenerationTimeNotAfterCryptographicConstraintsExpirationCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, timestamp, cryptographicValidation, this.getFailLevelConstraint());
    }

    private ChainItem<T> basicValidationProcess(XmlConclusion xmlConclusion) {
        return new BasicValidationProcessCheck<XmlConstraintsConclusion>(this.i18nProvider, this.result, xmlConclusion, this.token, this.getFailLevelConstraint());
    }

    protected List<TimestampWrapper> getContentTimestamps() {
        return Collections.emptyList();
    }

    protected XmlValidationProcessTimestamp getTimestampValidation(String timestampId) {
        return null;
    }

    private Date getRevocationTimeForSigningCertificate() {
        CertificateWrapper signingCertificate = this.token.getSigningCertificate();
        if (signingCertificate != null && Utils.isCollectionNotEmpty((Collection)signingCertificate.getCertificateRevocationData())) {
            return this.diagnosticData.getLatestRevocationDataForCertificate(signingCertificate).getRevocationDate();
        }
        return null;
    }

    private boolean isSignatureValueConcernedByFailure(XmlCryptographicValidation cryptographicValidation) {
        return this.token.getId().equals(cryptographicValidation.getConcernedMaterial());
    }

    @Override
    protected void collectMessages(XmlConclusion conclusion, XmlConstraint constraint) {
        if (XmlBlockType.CNT_TST_BBB.equals((Object)constraint.getBlockType())) {
            XmlMessage error = constraint.getError();
            if (error != null) {
                conclusion.getErrors().add(error);
            }
            super.collectMessages(conclusion, constraint);
        }
    }

    @Override
    protected void collectAdditionalMessages(XmlConclusion conclusion) {
        XmlBasicBuildingBlocks tokenBBBs = this.bbbs.get(this.token.getId());
        if (tokenBBBs != null) {
            conclusion.getErrors().clear();
            conclusion.getErrors().addAll(tokenBBBs.getConclusion().getErrors());
            conclusion.getWarnings().clear();
            conclusion.getWarnings().addAll(tokenBBBs.getConclusion().getWarnings());
            conclusion.getInfos().clear();
            conclusion.getInfos().addAll(tokenBBBs.getConclusion().getInfos());
            for (XmlConstraint constraint : this.result.getConstraint()) {
                this.collectMessages(conclusion, constraint);
            }
        }
    }
}

