/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks.type;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.CertificateType;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.QCTypeIdentifiers;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeStrategy;

class TypeByCertificatePostEIDAS
implements TypeStrategy {
    private final CertificateWrapper signingCertificate;

    public TypeByCertificatePostEIDAS(CertificateWrapper signingCertificate) {
        this.signingCertificate = signingCertificate;
    }

    @Override
    public CertificateType getType() {
        boolean esign = QCTypeIdentifiers.isQCTypeEsign(this.signingCertificate);
        boolean eseal = QCTypeIdentifiers.isQCTypeEseal(this.signingCertificate);
        boolean web = QCTypeIdentifiers.isQCTypeWeb(this.signingCertificate);
        boolean noneType = !esign && !eseal && !web;
        boolean onlyOne = esign ^ eseal ^ web;
        if (noneType || esign && onlyOne) {
            return CertificateType.ESIGN;
        }
        if (eseal && onlyOne) {
            return CertificateType.ESEAL;
        }
        if (web && onlyOne) {
            return CertificateType.WSA;
        }
        return CertificateType.UNKNOWN;
    }
}

