/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;

public class RevocationIssuerTrustedCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final CertificateWrapper certificate;

    public RevocationIssuerTrustedCheck(I18nProvider i18nProvider, T result, CertificateWrapper certificate, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
    }

    @Override
    protected boolean process() {
        return this.certificate != null && this.certificate.isTrusted();
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.PSV_ICRDIT;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.PSV_ICRDIT_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return null;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }

    @Override
    protected String buildAdditionalInfo() {
        if (this.certificate != null) {
            return this.i18nProvider.getMessage(MessageTag.CERTIFICATE_ID, new Object[]{this.certificate.getId()});
        }
        return null;
    }
}

