/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRAC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class ValidationProcessUtils {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm";

    public static boolean isRevocationCheckRequired(CertificateWrapper certificate) {
        return !certificate.isTrusted() && !certificate.isSelfSigned() && !certificate.isIdPkixOcspNoCheck();
    }

    public static boolean isAllowedBasicSignatureValidation(XmlConclusion conclusion) {
        return Indication.PASSED.equals((Object)conclusion.getIndication()) || Indication.INDETERMINATE.equals((Object)conclusion.getIndication()) && (SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.REVOKED_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.REVOKED_CA_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.TRY_LATER.equals((Object)conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals((Object)conclusion.getSubIndication()));
    }

    public static boolean isAllowedBasicRevocationDataValidation(XmlConclusion conclusion) {
        return Indication.PASSED.equals((Object)conclusion.getIndication()) || Indication.INDETERMINATE.equals((Object)conclusion.getIndication()) && (SubIndication.REVOKED_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.REVOKED_CA_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals((Object)conclusion.getSubIndication()) || SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.REVOCATION_OUT_OF_BOUNDS_NO_POE.equals((Object)conclusion.getSubIndication()));
    }

    public static boolean isAllowedBasicTimestampValidation(XmlConclusion conclusion) {
        return Indication.PASSED.equals((Object)conclusion.getIndication()) || Indication.INDETERMINATE.equals((Object)conclusion.getIndication()) && (SubIndication.REVOKED_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.REVOKED_CA_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals((Object)conclusion.getSubIndication()) || SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.REVOCATION_OUT_OF_BOUNDS_NO_POE.equals((Object)conclusion.getSubIndication()));
    }

    public static boolean isAllowedValidationWithLongTermData(XmlConclusion conclusion) {
        return Indication.PASSED.equals((Object)conclusion.getIndication()) || Indication.INDETERMINATE.equals((Object)conclusion.getIndication()) && (SubIndication.REVOKED_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.REVOKED_CA_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals((Object)conclusion.getSubIndication()) || SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.REVOCATION_OUT_OF_BOUNDS_NO_POE.equals((Object)conclusion.getSubIndication()));
    }

    public static CertificateRevocationWrapper getLatestAcceptableRevocationData(TokenProxy token, CertificateWrapper certificate, Collection<CertificateRevocationWrapper> revocationData, Date controlTime, Map<String, XmlBasicBuildingBlocks> bbbs, POEExtraction poe) {
        CertificateRevocationWrapper latestRevocationData = null;
        if (poe.isPOEExists(certificate.getId(), controlTime)) {
            for (CertificateRevocationWrapper revocationWrapper : revocationData) {
                XmlBasicBuildingBlocks revocationBBB = bbbs.get(revocationWrapper.getId());
                if (!ValidationProcessUtils.isAllowedBasicRevocationDataValidation(revocationBBB.getConclusion()) || !ValidationProcessUtils.isRevocationDataAcceptable(bbbs.get(token.getId()), certificate, (RevocationWrapper)revocationWrapper) || revocationWrapper.getProductionDate() == null || !revocationWrapper.getProductionDate().before(controlTime) || !poe.isPOEExists(revocationWrapper.getId(), controlTime) || latestRevocationData != null && !revocationWrapper.getProductionDate().after(latestRevocationData.getProductionDate())) continue;
                latestRevocationData = revocationWrapper;
            }
        }
        return latestRevocationData;
    }

    public static List<CertificateRevocationWrapper> getAcceptableRevocationDataForPSVIfExistOrReturnAll(TokenProxy token, CertificateWrapper certificate, Map<String, XmlBasicBuildingBlocks> bbbs, POEExtraction poe) {
        List<CertificateRevocationWrapper> revocationWrappers = ValidationProcessUtils.filterRevocationDataForPastSignatureValidation(token, certificate, bbbs, poe);
        if (Utils.isCollectionNotEmpty(revocationWrappers)) {
            return revocationWrappers;
        }
        return certificate.getCertificateRevocationData();
    }

    private static List<CertificateRevocationWrapper> filterRevocationDataForPastSignatureValidation(TokenProxy token, CertificateWrapper certificate, Map<String, XmlBasicBuildingBlocks> bbbs, POEExtraction poe) {
        ArrayList<CertificateRevocationWrapper> certificateRevocations = new ArrayList<CertificateRevocationWrapper>();
        for (CertificateRevocationWrapper certificateRevocation : certificate.getCertificateRevocationData()) {
            XmlBasicBuildingBlocks revocationBBB = bbbs.get(certificateRevocation.getId());
            CertificateWrapper revocationIssuer = certificateRevocation.getSigningCertificate();
            if (!ValidationProcessUtils.isAllowedBasicRevocationDataValidation(revocationBBB.getConclusion()) || !ValidationProcessUtils.isRevocationDataAcceptable(bbbs.get(token.getId()), certificate, (RevocationWrapper)certificateRevocation) || revocationIssuer == null || !revocationIssuer.isTrusted() && !poe.isPOEExistInRange(revocationIssuer.getId(), revocationIssuer.getNotBefore(), revocationIssuer.getNotAfter())) continue;
            certificateRevocations.add(certificateRevocation);
        }
        return certificateRevocations;
    }

    public static boolean isRevocationDataAcceptable(XmlBasicBuildingBlocks bbb, CertificateWrapper certificate, RevocationWrapper revocationData) {
        XmlRAC xmlRAC = ValidationProcessUtils.getRevocationAcceptanceCheckerResult(bbb, certificate, revocationData);
        return xmlRAC != null && xmlRAC.getConclusion() != null && Indication.PASSED.equals((Object)xmlRAC.getConclusion().getIndication());
    }

    public static XmlRAC getRevocationAcceptanceCheckerResult(XmlBasicBuildingBlocks bbb, CertificateWrapper certificate, RevocationWrapper revocationData) {
        XmlXCV xcv;
        if (bbb != null && (xcv = bbb.getXCV()) != null) {
            for (XmlSubXCV subXCV : xcv.getSubXCV()) {
                List racs;
                if (!certificate.getId().equals(subXCV.getId()) || !Utils.isCollectionNotEmpty((Collection)(racs = subXCV.getRAC()))) continue;
                for (XmlRAC rac : racs) {
                    if (!revocationData.getId().equals(rac.getId())) continue;
                    return rac;
                }
            }
        }
        return null;
    }

    public static String getFormattedDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date);
    }

    public static String buildStringMessage(I18nProvider i18nProvider, MessageTag messageTag, Object ... args) {
        if (messageTag != null) {
            return i18nProvider.getMessage(messageTag, args);
        }
        return null;
    }

    public static MessageTag getCryptoPosition(Context context) {
        switch (context) {
            case SIGNATURE: 
            case COUNTER_SIGNATURE: {
                return MessageTag.ACCM_POS_SIG_SIG;
            }
            case TIMESTAMP: {
                return MessageTag.ACCM_POS_TST_SIG;
            }
            case REVOCATION: {
                return MessageTag.ACCM_POS_REVOC_SIG;
            }
            case CERTIFICATE: {
                return MessageTag.ACCM_POS_CERT_CHAIN;
            }
        }
        throw new IllegalArgumentException("Unsupported context " + context);
    }

    public static MessageTag getCertificateChainCryptoPosition(Context context) {
        switch (context) {
            case SIGNATURE: 
            case COUNTER_SIGNATURE: {
                return MessageTag.ACCM_POS_CERT_CHAIN_SIG;
            }
            case TIMESTAMP: {
                return MessageTag.ACCM_POS_CERT_CHAIN_TST;
            }
            case REVOCATION: {
                return MessageTag.ACCM_POS_CERT_CHAIN_REVOC;
            }
            case CERTIFICATE: {
                return MessageTag.ACCM_POS_CERT_CHAIN;
            }
        }
        throw new IllegalArgumentException("Unsupported context " + context);
    }

    public static MessageTag getDigestMatcherCryptoPosition(XmlDigestMatcher digestMatcher) {
        switch (digestMatcher.getType()) {
            case OBJECT: 
            case REFERENCE: 
            case XPOINTER: {
                return MessageTag.ACCM_POS_REF;
            }
            case MANIFEST: {
                return MessageTag.ACCM_POS_MAN;
            }
            case MANIFEST_ENTRY: {
                return MessageTag.ACCM_POS_MAN_ENT;
            }
            case SIGNED_PROPERTIES: {
                return MessageTag.ACCM_POS_SIGND_PRT;
            }
            case KEY_INFO: {
                return MessageTag.ACCM_POS_KEY;
            }
            case SIGNATURE_PROPERTIES: {
                return MessageTag.ACCM_POS_SIGNTR_PRT;
            }
            case COUNTER_SIGNATURE: 
            case COUNTER_SIGNED_SIGNATURE_VALUE: {
                return MessageTag.ACCM_POS_CNTR_SIG;
            }
            case MESSAGE_DIGEST: {
                return MessageTag.ACCM_POS_MES_DIG;
            }
            case CONTENT_DIGEST: {
                return MessageTag.ACCM_POS_CON_DIG;
            }
            case JWS_SIGNING_INPUT_DIGEST: {
                return MessageTag.ACCM_POS_JWS;
            }
            case SIG_D_ENTRY: {
                return MessageTag.ACCM_POS_SIG_D_ENT;
            }
            case MESSAGE_IMPRINT: {
                return MessageTag.ACCM_POS_MESS_IMP;
            }
        }
        throw new IllegalArgumentException(String.format("The provided DigestMatcherType '%s' is not supported!", digestMatcher.getType()));
    }

    public static MessageTag getTimestampTypeMessageTag(TimestampType timestampType) {
        if (timestampType.isContentTimestamp()) {
            return MessageTag.TST_TYPE_CONTENT_TST;
        }
        if (timestampType.isSignatureTimestamp()) {
            return MessageTag.TST_TYPE_SIGNATURE_TST;
        }
        if (timestampType.isValidationDataTimestamp()) {
            return MessageTag.TST_TYPE_VD_TST;
        }
        if (timestampType.isDocumentTimestamp()) {
            return MessageTag.TST_TYPE_DOC_TST;
        }
        if (timestampType.isArchivalTimestamp()) {
            return MessageTag.TST_TYPE_ARCHIVE_TST;
        }
        throw new IllegalArgumentException(String.format("The TimestampType '%s' is not supported!", timestampType));
    }

    public static boolean isValidRACFound(XmlSubXCV subXCV) {
        for (XmlRAC rac : subXCV.getRAC()) {
            if (rac == null || rac.getConclusion() == null || !Indication.PASSED.equals((Object)rac.getConclusion().getIndication())) continue;
            return true;
        }
        return false;
    }

    public static boolean isMessageCollectingRequiredForRevocation(String revocationId, List<CertificateWrapper> certificateChain, Map<CertificateWrapper, CertificateRevocationWrapper> certificateRevocationMap) {
        for (CertificateWrapper certificateWrapper : certificateChain) {
            if (!ValidationProcessUtils.isRevocationRelatedToCertificate(certificateWrapper, revocationId) || ValidationProcessUtils.isCertificateRevocationValid(certificateWrapper, certificateRevocationMap)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRevocationRelatedToCertificate(CertificateWrapper certificateWrapper, String revocationId) {
        for (CertificateRevocationWrapper certificateRevocationWrapper : certificateWrapper.getCertificateRevocationData()) {
            if (!revocationId.equals(certificateRevocationWrapper.getId())) continue;
            return true;
        }
        return false;
    }

    private static boolean isCertificateRevocationValid(CertificateWrapper certificateWrapper, Map<CertificateWrapper, CertificateRevocationWrapper> certificateRevocationMap) {
        if (certificateWrapper.isTrusted()) {
            return true;
        }
        return certificateRevocationMap.get(certificateWrapper) != null;
    }
}

