/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfltvd.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessLongTermData;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public class RevocationDateAfterBestSignatureTimeCheck
extends ChainItem<XmlValidationProcessLongTermData> {
    private final CertificateRevocationWrapper certificateRevocation;
    private final Date bestSignatureTime;
    private final SubContext subContext;

    public RevocationDateAfterBestSignatureTimeCheck(I18nProvider i18nProvider, XmlValidationProcessLongTermData result, CertificateRevocationWrapper certificateRevocation, Date bestSignatureTime, LevelConstraint constraint, SubContext subContext) {
        super(i18nProvider, result, constraint);
        this.certificateRevocation = certificateRevocation;
        this.bestSignatureTime = bestSignatureTime;
        this.subContext = subContext;
    }

    @Override
    protected boolean process() {
        Date revocationDate = this.certificateRevocation.getRevocationDate();
        return revocationDate != null && revocationDate.after(this.bestSignatureTime);
    }

    @Override
    protected MessageTag getAdditionalInfo() {
        String bestSignatureTimeStr = this.bestSignatureTime == null ? " ? " : ValidationProcessUtils.getFormattedDate(this.bestSignatureTime);
        return MessageTag.BEST_SIGNATURE_TIME.setArgs(new Object[]{bestSignatureTimeStr});
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ADEST_IRTPTBST;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.ADEST_IRTPTBST_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        if (SubContext.SIGNING_CERT.equals((Object)this.subContext)) {
            return SubIndication.REVOKED_NO_POE;
        }
        return SubIndication.REVOKED_CA_NO_POE;
    }
}

