/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate;

import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.enumerations.CertificateQualification;
import eu.europa.esig.dss.enumerations.ValidationTime;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertQualificationMatrix;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertificateQualificationCalculation;
import eu.europa.esig.dss.validation.process.qualification.certificate.QSCDStatus;
import eu.europa.esig.dss.validation.process.qualification.certificate.QualifiedStatus;
import eu.europa.esig.dss.validation.process.qualification.certificate.Type;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.CaQcCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.CertificateIssuedByConsistentTrustServiceCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.CertificateTypeCoverageCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.ForEsigCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.GrantedStatusCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.IsAbleToSelectOneTrustService;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.IsQualificationConflictDetected;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.QSCDCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.QualifiedCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.ServiceConsistencyCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.TrustedCertificateMatchTrustServiceCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDStrategy;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDStrategyFactory;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified.QualificationStrategy;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified.QualificationStrategyFactory;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeStrategy;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeStrategyFactory;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServicesFilterFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CertQualificationAtTimeBlock
extends Chain<XmlValidationCertificateQualification> {
    private final ValidationTime validationTime;
    private final Date date;
    private final CertificateWrapper signingCertificate;
    private final List<TrustedServiceWrapper> caqcServices;
    private CertificateQualification certificateQualification = CertificateQualification.NA;

    public CertQualificationAtTimeBlock(I18nProvider i18nProvider, ValidationTime validationTime, CertificateWrapper signingCertificate, List<TrustedServiceWrapper> caqcServices) {
        this(i18nProvider, validationTime, null, signingCertificate, caqcServices);
    }

    public CertQualificationAtTimeBlock(I18nProvider i18nProvider, ValidationTime validationTime, Date date, CertificateWrapper signingCertificate, List<TrustedServiceWrapper> caqcServices) {
        super(i18nProvider, new XmlValidationCertificateQualification());
        ((XmlValidationCertificateQualification)this.result).setId(signingCertificate.getId());
        this.validationTime = validationTime;
        this.signingCertificate = signingCertificate;
        this.caqcServices = new ArrayList<TrustedServiceWrapper>(caqcServices);
        switch (validationTime) {
            case CERTIFICATE_ISSUANCE_TIME: {
                this.date = signingCertificate.getNotBefore();
                break;
            }
            case VALIDATION_TIME: 
            case BEST_SIGNATURE_TIME: {
                this.date = date;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown qualification time : " + validationTime);
            }
        }
    }

    @Override
    protected MessageTag getTitle() {
        MessageTag param;
        MessageTag message = MessageTag.CERT_QUALIFICATION_AT_TIME;
        switch (this.validationTime) {
            case BEST_SIGNATURE_TIME: {
                param = MessageTag.VT_BEST_SIGNATURE_TIME;
                break;
            }
            case CERTIFICATE_ISSUANCE_TIME: {
                param = MessageTag.VT_CERTIFICATE_ISSUANCE_TIME;
                break;
            }
            case VALIDATION_TIME: {
                param = MessageTag.VT_VALIDATION_TIME;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The validation time [%s] is not supported", this.validationTime));
            }
        }
        return message.setArgs(new Object[]{param});
    }

    @Override
    protected void initChain() {
        ChainItem<XmlValidationCertificateQualification> item;
        TrustedServiceFilter filterByDate = TrustedServicesFilterFactory.createFilterByDate(this.date);
        List<TrustedServiceWrapper> caqcServicesAtTime = filterByDate.filter(this.caqcServices);
        this.firstItem = item = this.hasCaQc(caqcServicesAtTime);
        for (TrustedServiceWrapper trustedServiceWrapper : caqcServicesAtTime) {
            item = item.setNextItem(this.serviceConsistency(trustedServiceWrapper));
        }
        if (caqcServicesAtTime.size() > 1) {
            HashSet<CertificateQualification> results = new HashSet<CertificateQualification>();
            for (TrustedServiceWrapper trustedService : caqcServicesAtTime) {
                CertificateQualificationCalculation calculator = new CertificateQualificationCalculation(this.signingCertificate, trustedService);
                results.add(calculator.getQualification());
            }
            item = item.setNextItem(this.isConflictDetected(results));
            if (results.size() > 1) {
                this.certificateQualification = CertificateQualification.NA;
                return;
            }
        }
        TrustedServiceFilter filterByGranted = TrustedServicesFilterFactory.createFilterByGranted();
        caqcServicesAtTime = filterByGranted.filter(caqcServicesAtTime);
        item = item.setNextItem(this.hasGrantedStatus(caqcServicesAtTime));
        TrustedServiceFilter trustedServiceFilter = TrustedServicesFilterFactory.createConsistentServiceFilter();
        caqcServicesAtTime = trustedServiceFilter.filter(caqcServicesAtTime);
        item = item.setNextItem(this.hasConsistentTrustService(caqcServicesAtTime));
        TrustedServiceFilter filterByCertificateType = TrustedServicesFilterFactory.createFilterByCertificateType(this.signingCertificate);
        caqcServicesAtTime = filterByCertificateType.filter(caqcServicesAtTime);
        item = item.setNextItem(this.hasCertificateTypeCoverage(caqcServicesAtTime));
        if (Utils.collectionSize(caqcServicesAtTime) > 1) {
            TrustedServiceFilter filterUnique = TrustedServicesFilterFactory.createUniqueServiceFilter(this.signingCertificate);
            caqcServicesAtTime = filterUnique.filter(caqcServicesAtTime);
            item = item.setNextItem(this.isAbleToSelectOneTrustService(caqcServicesAtTime));
        }
        TrustedServiceWrapper selectedTrustService = !caqcServicesAtTime.isEmpty() ? caqcServicesAtTime.get(0) : null;
        item = item.setNextItem(this.isTrustedCertificateMatchTrustService(selectedTrustService));
        QualificationStrategy qcStrategy = QualificationStrategyFactory.createQualificationFromCertAndTL(this.signingCertificate, selectedTrustService);
        QualifiedStatus qualifiedStatus = qcStrategy.getQualifiedStatus();
        item = item.setNextItem(this.isQualified(qualifiedStatus));
        TypeStrategy typeStrategy = TypeStrategyFactory.createTypeFromCertAndTL(this.signingCertificate, selectedTrustService, qualifiedStatus);
        Type type = typeStrategy.getType();
        item = item.setNextItem(this.isForEsig(type));
        QSCDStrategy qscdStrategy = QSCDStrategyFactory.createQSCDFromCertAndTL(this.signingCertificate, selectedTrustService, qualifiedStatus);
        QSCDStatus qscdStatus = qscdStrategy.getQSCDStatus();
        item = item.setNextItem(this.isQscd(qscdStatus));
        this.certificateQualification = CertQualificationMatrix.getCertQualification(qualifiedStatus, type, qscdStatus);
    }

    @Override
    protected void addAdditionalInfo() {
        ((XmlValidationCertificateQualification)this.result).setCertificateQualification(this.certificateQualification);
        ((XmlValidationCertificateQualification)this.result).setValidationTime(this.validationTime);
        ((XmlValidationCertificateQualification)this.result).setDateTime(this.date);
    }

    private ChainItem<XmlValidationCertificateQualification> hasCaQc(List<TrustedServiceWrapper> caqcServicesAtTime) {
        return new CaQcCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, caqcServicesAtTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> isConflictDetected(Set<CertificateQualification> certificateQualificationsAtTime) {
        return new IsQualificationConflictDetected(this.i18nProvider, (XmlValidationCertificateQualification)this.result, certificateQualificationsAtTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> hasGrantedStatus(List<TrustedServiceWrapper> caqcServicesAtTime) {
        return new GrantedStatusCheck<XmlValidationCertificateQualification>(this.i18nProvider, (XmlValidationCertificateQualification)this.result, caqcServicesAtTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> hasCertificateTypeCoverage(List<TrustedServiceWrapper> caqcServicesAtTime) {
        return new CertificateTypeCoverageCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, caqcServicesAtTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> hasConsistentTrustService(List<TrustedServiceWrapper> caqcServicesAtTime) {
        return new CertificateIssuedByConsistentTrustServiceCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, caqcServicesAtTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> isAbleToSelectOneTrustService(List<TrustedServiceWrapper> caqcServicesAtTime) {
        return new IsAbleToSelectOneTrustService(this.i18nProvider, (XmlValidationCertificateQualification)this.result, caqcServicesAtTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> serviceConsistency(TrustedServiceWrapper selectedTrustService) {
        return new ServiceConsistencyCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, selectedTrustService, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> isTrustedCertificateMatchTrustService(TrustedServiceWrapper selectedTrustService) {
        return new TrustedCertificateMatchTrustServiceCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, selectedTrustService, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> isQualified(QualifiedStatus qualifiedStatus) {
        return new QualifiedCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, qualifiedStatus, this.validationTime, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> isForEsig(Type type) {
        return new ForEsigCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, type, this.validationTime, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> isQscd(QSCDStatus qscdStatus) {
        return new QSCDCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, qscdStatus, this.validationTime, this.getWarnLevelConstraint());
    }
}

