/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public class IdPkixOcspNoCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final CertificateWrapper certificate;
    private final Date controlTime;

    public IdPkixOcspNoCheck(I18nProvider i18nProvider, T result, CertificateWrapper certificateWrapper, Date controlTime, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificateWrapper;
        this.controlTime = controlTime;
    }

    @Override
    protected boolean process() {
        return this.controlTime.compareTo(this.certificate.getNotBefore()) >= 0 && this.controlTime.compareTo(this.certificate.getNotAfter()) <= 0;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_OCSP_NO_CHECK;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_OCSP_NO_CHECK_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return null;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }

    @Override
    protected MessageTag getAdditionalInfo() {
        String notBeforeStr = this.certificate.getNotBefore() == null ? " ? " : ValidationProcessUtils.getFormattedDate(this.certificate.getNotBefore());
        String notAfterStr = this.certificate.getNotAfter() == null ? " ? " : ValidationProcessUtils.getFormattedDate(this.certificate.getNotAfter());
        String validationTime = ValidationProcessUtils.getFormattedDate(this.controlTime);
        Object[] params = new Object[]{notBeforeStr, notAfterStr, validationTime};
        return MessageTag.OCSP_NO_CHECK.setArgs(params);
    }
}

