/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.RevocationReason;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public class CertificateOnHoldCheck
extends ChainItem<XmlSubXCV> {
    private final CertificateRevocationWrapper certificateRevocation;
    private final Date currentTime;

    public CertificateOnHoldCheck(I18nProvider i18nProvider, XmlSubXCV result, CertificateRevocationWrapper certificateRevocation, Date currentTime, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.certificateRevocation = certificateRevocation;
        this.currentTime = currentTime;
    }

    @Override
    protected boolean process() {
        boolean isOnHold;
        boolean bl = isOnHold = this.certificateRevocation != null && this.certificateRevocation.isRevoked() && RevocationReason.CERTIFICATE_HOLD.equals((Object)this.certificateRevocation.getReason());
        if (isOnHold) {
            isOnHold = this.certificateRevocation.getRevocationDate() != null && this.currentTime.compareTo(this.certificateRevocation.getRevocationDate()) >= 0;
        }
        return !isOnHold;
    }

    @Override
    protected MessageTag getAdditionalInfo() {
        if (this.certificateRevocation != null && this.certificateRevocation.getRevocationDate() != null) {
            String revocationDateStr = ValidationProcessUtils.getFormattedDate(this.certificateRevocation.getRevocationDate());
            return MessageTag.REVOCATION.setArgs(new Object[]{this.certificateRevocation.getReason(), revocationDateStr});
        }
        return null;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_ISCOH;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_ISCOH_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.TRY_LATER;
    }
}

