/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public class CertificateExpirationCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final Date currentTime;
    private final CertificateWrapper certificate;
    private final CertificateRevocationWrapper usedCertificateRevocation;
    private SubIndication subIndication;

    public CertificateExpirationCheck(I18nProvider i18nProvider, T result, CertificateWrapper certificate, CertificateRevocationWrapper usedCertificateRevocation, Date currentTime, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.currentTime = currentTime;
        this.certificate = certificate;
        this.usedCertificateRevocation = usedCertificateRevocation;
    }

    @Override
    protected boolean process() {
        boolean inValidityRange = this.isInValidityRange();
        if (!inValidityRange) {
            this.subIndication = SubIndication.OUT_OF_BOUNDS_NO_POE;
            if (ValidationProcessUtils.isRevocationCheckRequired(this.certificate, this.currentTime) && this.usedCertificateRevocation != null && !this.usedCertificateRevocation.isRevoked()) {
                this.subIndication = SubIndication.OUT_OF_BOUNDS_NOT_REVOKED;
            }
        }
        return inValidityRange;
    }

    private boolean isInValidityRange() {
        Date notBefore = this.certificate.getNotBefore();
        Date notAfter = this.certificate.getNotAfter();
        return notBefore != null && this.currentTime.compareTo(notBefore) >= 0 && notAfter != null && this.currentTime.compareTo(notAfter) <= 0;
    }

    @Override
    protected MessageTag getAdditionalInfo() {
        String notBeforeStr = this.certificate.getNotBefore() == null ? " ? " : ValidationProcessUtils.getFormattedDate(this.certificate.getNotBefore());
        String notAfterStr = this.certificate.getNotAfter() == null ? " ? " : ValidationProcessUtils.getFormattedDate(this.certificate.getNotAfter());
        Object[] params = new Object[]{notBeforeStr, notAfterStr};
        return MessageTag.CERTIFICATE_VALIDITY.setArgs(params);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_ICTIVRSC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_ICTIVRSC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.subIndication;
    }
}

