/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRAC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRFC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRevocationInformation;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.RevocationAcceptanceChecker;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.LatestRevocationAcceptanceCheckerResultCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationAcceptanceCheckerResultCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.RevocationFreshnessChecker;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks.RevocationDataAvailableCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.AuthorityInfoAccessPresentCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateCryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateExpirationCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateIssuedToLegalPersonCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateIssuedToNaturalPersonCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateNotSelfSignedCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateOnHoldCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificatePolicyIdsCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQCStatementIdsCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQualifiedCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateRevokedCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateSelfSignedCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateSignatureValidCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateSupportedByQSCDCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CommonNameCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CountryCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.ExtendedKeyUsageCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.GivenNameCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.IdPkixOcspNoCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.KeyUsageCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.OrganizationNameCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.OrganizationUnitCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.PseudoUsageCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.PseudonymCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationFreshnessCheckerResultCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationInfoAccessPresentCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.SerialNumberCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.SurnameCheck;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SubX509CertificateValidation
extends Chain<XmlSubXCV> {
    private final CertificateWrapper currentCertificate;
    private final Date currentTime;
    private final Context context;
    private final SubContext subContext;
    private final ValidationPolicy validationPolicy;

    public SubX509CertificateValidation(I18nProvider i18nProvider, CertificateWrapper currentCertificate, Date currentTime, Context context, SubContext subContext, ValidationPolicy validationPolicy) {
        super(i18nProvider, new XmlSubXCV());
        ((XmlSubXCV)this.result).setId(currentCertificate.getId());
        ((XmlSubXCV)this.result).setTrustAnchor(Boolean.valueOf(currentCertificate.isTrusted()));
        ((XmlSubXCV)this.result).setSelfSigned(Boolean.valueOf(currentCertificate.isSelfSigned()));
        this.currentCertificate = currentCertificate;
        this.currentTime = currentTime;
        this.context = context;
        this.subContext = subContext;
        this.validationPolicy = validationPolicy;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.SUB_XCV;
    }

    @Override
    protected void initChain() {
        if (this.currentCertificate.isTrusted()) {
            return;
        }
        ChainItem<XmlSubXCV> item = this.firstItem = this.serialNumber(this.currentCertificate, this.subContext);
        item = item.setNextItem(this.surname(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.givenName(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.commonName(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.pseudoUsage(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.pseudonym(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.country(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.organizationUnit(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.organizationName(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.selfSigned(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.notSelfSigned(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificatePolicyIds(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQCStatementIds(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQualified(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateSupportedByQSCD(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateIssuedToLegalPerson(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateIssuedToNaturalPerson(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateSignatureValid(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.keyUsage(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.extendedKeyUsage(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.aiaPresent(this.currentCertificate, this.subContext));
        CertificateRevocationWrapper latestCertificateRevocation = null;
        if (this.currentCertificate.isIdPkixOcspNoCheck()) {
            item = item.setNextItem(this.idPkixOcspNoCheck(this.currentCertificate));
        }
        if (ValidationProcessUtils.isRevocationCheckRequired(this.currentCertificate, this.currentTime)) {
            item = item.setNextItem(this.revocationInfoAccessPresent(this.currentCertificate, this.subContext));
            item = item.setNextItem(this.revocationDataPresent(this.currentCertificate, this.subContext));
            Map<CertificateRevocationWrapper, XmlRAC> revocationAcceptanceResultMap = this.getRevocationAcceptanceResult(this.currentCertificate);
            for (Map.Entry<CertificateRevocationWrapper, XmlRAC> revocationAcceptanceResult : revocationAcceptanceResultMap.entrySet()) {
                CertificateRevocationWrapper currentRevocation = revocationAcceptanceResult.getKey();
                XmlRAC currentRAC = revocationAcceptanceResult.getValue();
                ((XmlSubXCV)this.result).getRAC().add(currentRAC);
                item = item.setNextItem(this.revocationAcceptable(currentRAC));
                if (!this.isValid((XmlConstraintsConclusion)currentRAC) || latestCertificateRevocation != null && !currentRevocation.getProductionDate().after(latestCertificateRevocation.getProductionDate())) continue;
                latestCertificateRevocation = currentRevocation;
            }
            if (latestCertificateRevocation != null && latestCertificateRevocation.isRevoked()) {
                this.attachRevocationInformation(latestCertificateRevocation);
            }
            if (latestCertificateRevocation != null) {
                item = item.setNextItem(this.latestRevocationAcceptable(revocationAcceptanceResultMap.get(latestCertificateRevocation)));
            }
            RevocationFreshnessChecker rfc = new RevocationFreshnessChecker(this.i18nProvider, (RevocationWrapper)latestCertificateRevocation, this.currentTime, this.context, this.subContext, this.validationPolicy);
            XmlRFC rfcResult = (XmlRFC)rfc.execute();
            ((XmlSubXCV)this.result).setRFC(rfcResult);
            item = item.setNextItem(this.checkRevocationFreshnessCheckerResult(rfcResult));
            item = item.setNextItem(this.certificateRevoked(latestCertificateRevocation, this.subContext));
            item = item.setNextItem(this.certificateOnHold(latestCertificateRevocation, this.subContext));
        }
        item = item.setNextItem(this.certificateCryptographic(this.currentCertificate, this.context, this.subContext));
        if (SubContext.SIGNING_CERT == this.subContext) {
            item = item.setNextItem(this.certificateExpiration(this.currentCertificate, latestCertificateRevocation, this.subContext));
        }
    }

    private void attachRevocationInformation(CertificateRevocationWrapper certificateRevocation) {
        XmlRevocationInformation revocationInfo = new XmlRevocationInformation();
        revocationInfo.setCertificateId(this.currentCertificate.getId());
        revocationInfo.setRevocationId(certificateRevocation.getId());
        revocationInfo.setRevocationDate(certificateRevocation.getRevocationDate());
        revocationInfo.setReason(certificateRevocation.getReason());
        ((XmlSubXCV)this.result).setRevocationInfo(revocationInfo);
    }

    private ChainItem<XmlSubXCV> certificateExpiration(CertificateWrapper certificate, CertificateRevocationWrapper usedCertificateRevocation, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateNotExpiredConstraint(this.context, subContext);
        return new CertificateExpirationCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, certificate, usedCertificateRevocation, this.currentTime, constraint);
    }

    private ChainItem<XmlSubXCV> keyUsage(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateKeyUsageConstraint(this.context, subContext);
        return new KeyUsageCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> extendedKeyUsage(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateExtendedKeyUsageConstraint(this.context, subContext);
        return new ExtendedKeyUsageCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> aiaPresent(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateAuthorityInfoAccessPresentConstraint(this.context, subContext);
        return new AuthorityInfoAccessPresentCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> revocationInfoAccessPresent(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateRevocationInfoAccessPresentConstraint(this.context, subContext);
        return new RevocationInfoAccessPresentCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> revocationDataPresent(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getRevocationDataAvailableConstraint(this.context, subContext);
        return new RevocationDataAvailableCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private Map<CertificateRevocationWrapper, XmlRAC> getRevocationAcceptanceResult(CertificateWrapper certificate) {
        HashMap<CertificateRevocationWrapper, XmlRAC> revocationAcceptanceResultMap = new HashMap<CertificateRevocationWrapper, XmlRAC>();
        for (CertificateRevocationWrapper revocationWrapper : certificate.getCertificateRevocationData()) {
            RevocationAcceptanceChecker rac = new RevocationAcceptanceChecker(this.i18nProvider, certificate, revocationWrapper, this.currentTime, this.validationPolicy);
            XmlRAC racResult = (XmlRAC)rac.execute();
            if (racResult.getConclusion().getIndication() == Indication.INDETERMINATE) {
                RevocationAcceptanceChecker additionalRac = new RevocationAcceptanceChecker(this.i18nProvider, certificate, revocationWrapper, revocationWrapper.getProductionDate(), this.validationPolicy);
                racResult = (XmlRAC)additionalRac.execute();
            }
            revocationAcceptanceResultMap.put(revocationWrapper, racResult);
        }
        return revocationAcceptanceResultMap;
    }

    private ChainItem<XmlSubXCV> revocationAcceptable(XmlRAC racResult) {
        return new RevocationAcceptanceCheckerResultCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, racResult, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlSubXCV> latestRevocationAcceptable(XmlRAC racResult) {
        return new LatestRevocationAcceptanceCheckerResultCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, racResult, this.getFailLevelConstraint());
    }

    private ChainItem<XmlSubXCV> checkRevocationFreshnessCheckerResult(XmlRFC rfcResult) {
        LevelConstraint constraint = this.validationPolicy.getCertificateRevocationFreshnessConstraint(this.context, this.subContext);
        return new RevocationFreshnessCheckerResultCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, rfcResult, constraint);
    }

    private ChainItem<XmlSubXCV> surname(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateSurnameConstraint(this.context, subContext);
        return new SurnameCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> givenName(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateGivenNameConstraint(this.context, subContext);
        return new GivenNameCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> commonName(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateCommonNameConstraint(this.context, subContext);
        return new CommonNameCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> pseudonym(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificatePseudonymConstraint(this.context, subContext);
        return new PseudonymCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> country(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateCountryConstraint(this.context, subContext);
        return new CountryCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> organizationName(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateOrganizationNameConstraint(this.context, subContext);
        return new OrganizationNameCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> organizationUnit(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateOrganizationUnitConstraint(this.context, subContext);
        return new OrganizationUnitCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> serialNumber(CertificateWrapper signingCertificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateSerialNumberConstraint(this.context, subContext);
        return new SerialNumberCheck(this.i18nProvider, (XmlSubXCV)this.result, signingCertificate, constraint);
    }

    private ChainItem<XmlSubXCV> pseudoUsage(CertificateWrapper signingCertificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificatePseudoUsageConstraint(this.context, subContext);
        return new PseudoUsageCheck(this.i18nProvider, (XmlSubXCV)this.result, signingCertificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateSignatureValid(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateSignatureConstraint(this.context, subContext);
        return new CertificateSignatureValidCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateRevoked(CertificateRevocationWrapper latestCertificateRevocation, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateNotRevokedConstraint(this.context, subContext);
        return new CertificateRevokedCheck(this.i18nProvider, (XmlSubXCV)this.result, latestCertificateRevocation, this.currentTime, constraint, subContext);
    }

    private ChainItem<XmlSubXCV> certificateOnHold(CertificateRevocationWrapper latestCertificateRevocation, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateNotOnHoldConstraint(this.context, subContext);
        return new CertificateOnHoldCheck(this.i18nProvider, (XmlSubXCV)this.result, latestCertificateRevocation, this.currentTime, constraint);
    }

    private ChainItem<XmlSubXCV> notSelfSigned(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateNotSelfSignedConstraint(this.context, subContext);
        return new CertificateNotSelfSignedCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> selfSigned(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateSelfSignedConstraint(this.context, subContext);
        return new CertificateSelfSignedCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificatePolicyIds(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificatePolicyIdsConstraint(this.context, subContext);
        return new CertificatePolicyIdsCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQCStatementIds(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateQCStatementIdsConstraint(this.context, subContext);
        return new CertificateQCStatementIdsCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateCryptographic(CertificateWrapper certificate, Context context, SubContext subcontext) {
        CryptographicConstraint cryptographicConstraint = this.validationPolicy.getCertificateCryptographicConstraint(context, subcontext);
        return new CertificateCryptographicCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, this.currentTime, cryptographicConstraint);
    }

    private ChainItem<XmlSubXCV> certificateQualified(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateQualificationConstraint(this.context, subContext);
        return new CertificateQualifiedCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateSupportedByQSCD(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateSupportedByQSCDConstraint(this.context, subContext);
        return new CertificateSupportedByQSCDCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateIssuedToLegalPerson(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateIssuedToLegalPersonConstraint(this.context, subContext);
        return new CertificateIssuedToLegalPersonCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateIssuedToNaturalPerson(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateIssuedToNaturalPersonConstraint(this.context, subContext);
        return new CertificateIssuedToNaturalPersonCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> idPkixOcspNoCheck(CertificateWrapper certificateWrapper) {
        return new IdPkixOcspNoCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, certificateWrapper, this.currentTime, this.getWarnLevelConstraint());
    }
}

