/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;

public class RevocationDataAvailableCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final CertificateWrapper certificate;

    public RevocationDataAvailableCheck(I18nProvider i18nProvider, T result, CertificateWrapper certificate, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
    }

    @Override
    protected boolean process() {
        return this.certificate.isRevocationDataAvailable();
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_IRDPFC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_IRDPFC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.TRY_LATER;
    }

    @Override
    protected MessageTag getAdditionalInfo() {
        return MessageTag.CERTIFICATE_ID.setArgs(new Object[]{this.certificate.getId()});
    }
}

