/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.rfc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlRFC;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.policy.jaxb.Level;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.TimeConstraint;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks.AcceptableRevocationDataAvailableCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks.NextUpdateCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks.RevocationDataFreshCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks.RevocationDataFreshCheckWithNullConstraint;
import java.util.Date;

public class RevocationFreshnessChecker
extends Chain<XmlRFC> {
    private final RevocationWrapper revocationData;
    private final Date validationDate;
    private final ValidationPolicy policy;
    private final Context context;
    private final SubContext subContext;

    public RevocationFreshnessChecker(I18nProvider i18nProvider, RevocationWrapper revocationData, Date validationDate, Context context, SubContext subContext, ValidationPolicy policy) {
        super(i18nProvider, new XmlRFC());
        if (revocationData != null) {
            ((XmlRFC)this.result).setId(revocationData.getId());
        }
        this.revocationData = revocationData;
        this.validationDate = validationDate;
        this.policy = policy;
        this.context = context;
        this.subContext = subContext;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.REVOCATION_FRESHNESS_CHECKER;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlRFC> item = this.firstItem = this.revocationDataAvailable(this.revocationData);
        if (this.revocationData != null) {
            ((XmlRFC)this.result).setId(this.revocationData.getId());
            TimeConstraint revocationFreshnessConstraint = this.policy.getRevocationFreshnessConstraint();
            if (revocationFreshnessConstraint == null || Level.IGNORE.equals((Object)revocationFreshnessConstraint.getLevel())) {
                item = item.setNextItem(this.nextUpdateCheck(this.revocationData));
            }
            item = item.setNextItem(this.revocationDataFreshCheck(this.revocationData, revocationFreshnessConstraint));
            item = item.setNextItem(this.revocationCryptographic(this.revocationData));
        }
    }

    private ChainItem<XmlRFC> revocationDataAvailable(RevocationWrapper revocationData) {
        LevelConstraint constraint = this.policy.getRevocationDataAvailableConstraint(this.context, this.subContext);
        return new AcceptableRevocationDataAvailableCheck<XmlRFC>(this.i18nProvider, (XmlRFC)this.result, revocationData, constraint);
    }

    private ChainItem<XmlRFC> nextUpdateCheck(RevocationWrapper revocationData) {
        LevelConstraint constraint = this.policy.getRevocationDataNextUpdatePresentConstraint(this.context, this.subContext);
        return new NextUpdateCheck(this.i18nProvider, (XmlRFC)this.result, revocationData, constraint);
    }

    private ChainItem<XmlRFC> revocationDataFreshCheck(RevocationWrapper revocationData, TimeConstraint revocationFreshnessConstraint) {
        if (revocationFreshnessConstraint != null) {
            return new RevocationDataFreshCheck(this.i18nProvider, (XmlRFC)this.result, revocationData, this.validationDate, revocationFreshnessConstraint);
        }
        return new RevocationDataFreshCheckWithNullConstraint(this.i18nProvider, (XmlRFC)this.result, revocationData, this.validationDate, this.getFailLevelConstraint());
    }

    private ChainItem<XmlRFC> revocationCryptographic(RevocationWrapper revocationData) {
        CryptographicConstraint cryptographicConstraint = this.policy.getSignatureCryptographicConstraint(Context.REVOCATION);
        return new CryptographicCheck<XmlRFC>(this.i18nProvider, (XmlRFC)this.result, (TokenProxy)revocationData, this.validationDate, cryptographicConstraint);
    }
}

