/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.AlgoExpirationDate;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicConstraintWrapper;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class AbstractCryptographicCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final CryptographicConstraintWrapper constraintWrapper;
    protected final Date validationDate;
    protected String failedAlgorithm = null;
    protected MessageTag errorMessage = MessageTag.EMPTY;

    protected AbstractCryptographicCheck(I18nProvider i18nProvider, T result, Date currentTime, CryptographicConstraint constraint) {
        super(i18nProvider, result, (LevelConstraint)constraint);
        this.validationDate = currentTime;
        this.constraintWrapper = new CryptographicConstraintWrapper(constraint);
    }

    protected boolean isPublicKeySizeKnown(String keyLengthUsedToSignThisToken) {
        if (!Utils.isStringDigits((String)keyLengthUsedToSignThisToken)) {
            this.errorMessage = MessageTag.ASCCM_ANS_6;
            return false;
        }
        return true;
    }

    protected boolean publicKeySizeIsAcceptable(EncryptionAlgorithm encryptionAlgo, String keyLengthUsedToSignThisToken) {
        String algoToFind = encryptionAlgo == null ? "" : encryptionAlgo.getName();
        Map<String, Integer> minimumKeySizes = this.constraintWrapper.getMinimumKeySizes();
        if (Utils.isMapNotEmpty(minimumKeySizes)) {
            Integer expectedMinimumKeySize;
            String keySize = keyLengthUsedToSignThisToken;
            int tokenKeySize = 0;
            if (Utils.isStringDigits((String)keySize)) {
                tokenKeySize = Integer.parseInt(keySize);
            }
            if (tokenKeySize < (expectedMinimumKeySize = minimumKeySizes.get(algoToFind))) {
                this.errorMessage = MessageTag.ASCCM_ANS_3;
                this.failedAlgorithm = this.getEncryptionDetails(encryptionAlgo, keyLengthUsedToSignThisToken);
                return false;
            }
        }
        return true;
    }

    protected boolean encryptionAlgorithmIsReliable(EncryptionAlgorithm encryptionAlgo) {
        String algoToFind = encryptionAlgo == null ? "" : encryptionAlgo.getName();
        List<String> supportedEncryptionAlgorithms = this.constraintWrapper.getSupportedEncryptionAlgorithms();
        if (Utils.isCollectionNotEmpty(supportedEncryptionAlgorithms) && !this.isIn(algoToFind, supportedEncryptionAlgorithms)) {
            this.errorMessage = MessageTag.ASCCM_ANS_1;
            this.failedAlgorithm = algoToFind;
            return false;
        }
        return true;
    }

    protected boolean digestAlgorithmIsReliable(DigestAlgorithm digestAlgo) {
        String algoToFind = digestAlgo == null ? "" : digestAlgo.getName();
        List<String> supportedDigestAlgorithms = this.constraintWrapper.getSupportedDigestAlgorithms();
        if (Utils.isCollectionNotEmpty(supportedDigestAlgorithms) && !this.isIn(algoToFind, supportedDigestAlgorithms)) {
            this.errorMessage = MessageTag.ASCCM_ANS_2;
            this.failedAlgorithm = algoToFind;
            return false;
        }
        return true;
    }

    protected boolean digestAlgorithmIsValidOnValidationDate(DigestAlgorithm digestAlgo) {
        String algoToFind = digestAlgo == null ? "" : digestAlgo.getName();
        Date expirationDate = this.constraintWrapper.getDigestAlgorithmExpirationDate(algoToFind);
        if (expirationDate == null) {
            this.errorMessage = MessageTag.ASCCM_ANS_4;
            this.failedAlgorithm = algoToFind;
            return false;
        }
        if (expirationDate.before(this.validationDate)) {
            this.errorMessage = MessageTag.ASCCM_ANS_5;
            this.failedAlgorithm = algoToFind;
            return false;
        }
        return true;
    }

    protected boolean encryptionAlgorithmIsValidOnValidationDate(EncryptionAlgorithm encryptionAlgo, String keyLengthUsedToSignThisToken) {
        Integer keyLength = Integer.parseInt(keyLengthUsedToSignThisToken);
        Date expirationDate = this.constraintWrapper.getExpirationDate(encryptionAlgo.getName(), keyLength);
        if (expirationDate == null) {
            this.errorMessage = MessageTag.ASCCM_ANS_4;
            this.failedAlgorithm = this.getEncryptionDetails(encryptionAlgo, keyLengthUsedToSignThisToken);
            return false;
        }
        if (expirationDate.before(this.validationDate)) {
            this.errorMessage = MessageTag.ASCCM_ANS_5;
            this.failedAlgorithm = this.getEncryptionDetails(encryptionAlgo, keyLengthUsedToSignThisToken);
            return false;
        }
        return true;
    }

    private String getEncryptionDetails(EncryptionAlgorithm encryptionAlgo, String keyLengthUsedToSignThisToken) {
        StringBuilder sb = new StringBuilder();
        sb.append("Algo : ");
        if (encryptionAlgo == null) {
            sb.append("?");
        } else {
            sb.append(encryptionAlgo.getName());
        }
        sb.append(" / Key Size : ");
        sb.append(keyLengthUsedToSignThisToken);
        return sb.toString();
    }

    private boolean isIn(String algoToFind, List<String> algos) {
        return algos.contains(algoToFind);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ASCCM;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return this.errorMessage;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE;
    }

    @Override
    protected MessageTag getAdditionalInfo() {
        String dateTime = ValidationProcessUtils.getFormattedDate(this.validationDate);
        if (Utils.isStringNotEmpty((String)this.failedAlgorithm)) {
            return MessageTag.CRYPTOGRAPHIC_CHECK_FAILURE.setArgs(new Object[]{this.failedAlgorithm, dateTime});
        }
        return MessageTag.VALIDATION_TIME.setArgs(new Object[]{dateTime});
    }

    protected boolean isExpirationDateAvailable(CryptographicConstraint constraint) {
        AlgoExpirationDate algoExpirationDate = constraint.getAlgoExpirationDate();
        return algoExpirationDate != null && Utils.isCollectionNotEmpty((Collection)algoExpirationDate.getAlgo());
    }
}

