/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicInformation;
import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlISC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlName;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlVCI;
import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class AbstractBasicBuildingBlocksCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final DiagnosticData diagnosticData;
    private final XmlBasicBuildingBlocks tokenBBB;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private Indication indication;
    private SubIndication subIndication;
    private List<XmlName> errors = new ArrayList<XmlName>();

    public AbstractBasicBuildingBlocksCheck(I18nProvider i18nProvider, T result, DiagnosticData diagnosticData, XmlBasicBuildingBlocks tokenBBB, Map<String, XmlBasicBuildingBlocks> bbbs, LevelConstraint constraint) {
        super(i18nProvider, result, constraint, tokenBBB.getId());
        this.diagnosticData = diagnosticData;
        this.tokenBBB = tokenBBB;
        this.bbbs = bbbs;
    }

    @Override
    protected boolean process() {
        XmlCV cv;
        XmlConclusion cvConclusion;
        XmlConclusion vciConclusion;
        XmlConclusion fcConclusion;
        XmlFC fc = this.tokenBBB.getFC();
        if (fc != null && !Indication.PASSED.equals((Object)(fcConclusion = fc.getConclusion()).getIndication())) {
            this.indication = Indication.FAILED;
            this.subIndication = SubIndication.FORMAT_FAILURE;
            this.errors.addAll(fcConclusion.getErrors());
            return false;
        }
        XmlISC isc = this.tokenBBB.getISC();
        XmlConclusion iscConclusion = isc.getConclusion();
        if (Indication.INDETERMINATE.equals((Object)iscConclusion.getIndication()) && SubIndication.NO_SIGNING_CERTIFICATE_FOUND.equals((Object)iscConclusion.getSubIndication())) {
            this.indication = iscConclusion.getIndication();
            this.subIndication = iscConclusion.getSubIndication();
            this.errors.addAll(iscConclusion.getErrors());
            return false;
        }
        XmlVCI vci = this.tokenBBB.getVCI();
        if (vci != null && Indication.INDETERMINATE.equals((Object)(vciConclusion = vci.getConclusion()).getIndication())) {
            this.indication = vciConclusion.getIndication();
            this.subIndication = vciConclusion.getSubIndication();
            this.errors.addAll(vciConclusion.getErrors());
            return false;
        }
        XmlXCV xcv = this.tokenBBB.getXCV();
        XmlConclusion x509ValidationStatus = null;
        if (xcv != null) {
            SignatureWrapper currentSignature;
            XmlConclusion xcvConclusion = x509ValidationStatus = xcv.getConclusion();
            x509ValidationStatus.setIndication(xcvConclusion.getIndication());
            x509ValidationStatus.setSubIndication(xcvConclusion.getSubIndication());
            this.errors.addAll(xcvConclusion.getErrors());
            if (Indication.INDETERMINATE.equals((Object)xcvConclusion.getIndication()) && SubIndication.REVOKED_NO_POE.equals((Object)xcvConclusion.getSubIndication())) {
                currentSignature = this.diagnosticData.getSignatureById(this.tokenBBB.getId());
                if (currentSignature != null && this.isThereValidContentTimestampAfterDate(currentSignature, this.getRevocationDateForSigningCertificate(currentSignature))) {
                    x509ValidationStatus.setIndication(Indication.FAILED);
                    x509ValidationStatus.setSubIndication(SubIndication.REVOKED);
                }
            } else if (Indication.INDETERMINATE.equals((Object)xcvConclusion.getIndication()) && (SubIndication.OUT_OF_BOUNDS_NO_POE.equals((Object)xcvConclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals((Object)xcvConclusion.getSubIndication())) && (currentSignature = this.diagnosticData.getSignatureById(this.tokenBBB.getId())) != null && this.isThereValidContentTimestampAfterDate(currentSignature, this.getExpirationDateForSigningCertificate(currentSignature))) {
                x509ValidationStatus.setIndication(Indication.FAILED);
                x509ValidationStatus.setSubIndication(SubIndication.EXPIRED);
            }
        }
        if (Indication.PASSED.equals((Object)(cvConclusion = (cv = this.tokenBBB.getCV()).getConclusion()).getIndication())) {
            if (x509ValidationStatus != null && !Indication.PASSED.equals((Object)x509ValidationStatus.getIndication())) {
                this.indication = x509ValidationStatus.getIndication();
                this.subIndication = x509ValidationStatus.getSubIndication();
                return false;
            }
        } else {
            this.indication = cvConclusion.getIndication();
            this.subIndication = cvConclusion.getSubIndication();
            this.errors.addAll(cvConclusion.getErrors());
            return false;
        }
        XmlSAV sav = this.tokenBBB.getSAV();
        XmlConclusion savConclusion = sav.getConclusion();
        if (Indication.INDETERMINATE.equals((Object)savConclusion.getIndication()) && SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals((Object)savConclusion.getSubIndication())) {
            XmlCryptographicInformation cryptographicInfo = sav.getCryptographicInfo();
            SignatureWrapper currentSignature = this.diagnosticData.getSignatureById(this.tokenBBB.getId());
            if (currentSignature != null && this.isThereValidContentTimestampAfterDate(currentSignature, cryptographicInfo.getNotAfter())) {
                this.indication = Indication.INDETERMINATE;
                this.subIndication = SubIndication.CRYPTO_CONSTRAINTS_FAILURE;
                return false;
            }
            this.indication = Indication.INDETERMINATE;
            this.subIndication = SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE;
            this.errors.addAll(savConclusion.getErrors());
            return false;
        }
        if (!Indication.PASSED.equals((Object)savConclusion.getIndication())) {
            this.indication = savConclusion.getIndication();
            this.subIndication = savConclusion.getSubIndication();
            this.errors.addAll(savConclusion.getErrors());
            return false;
        }
        return true;
    }

    private boolean isThereValidContentTimestampAfterDate(SignatureWrapper currentSignature, Date date) {
        List contentTimestamps = currentSignature.getContentTimestamps();
        if (Utils.isCollectionNotEmpty((Collection)contentTimestamps)) {
            for (TimestampWrapper timestamp : contentTimestamps) {
                Date tspProductionTime;
                if (!this.isValidTimestamp(timestamp) || !(tspProductionTime = timestamp.getProductionTime()).after(date)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isValidTimestamp(TimestampWrapper timestamp) {
        XmlBasicBuildingBlocks timestampBasicBuildingBlocks = this.bbbs.get(timestamp.getId());
        return timestampBasicBuildingBlocks != null && timestampBasicBuildingBlocks.getConclusion() != null && Indication.PASSED.equals((Object)timestampBasicBuildingBlocks.getConclusion().getIndication());
    }

    private Date getRevocationDateForSigningCertificate(SignatureWrapper currentSignature) {
        CertificateWrapper signingCertificate = currentSignature.getSigningCertificate();
        if (signingCertificate != null && Utils.isCollectionNotEmpty((Collection)signingCertificate.getCertificateRevocationData())) {
            return this.diagnosticData.getLatestRevocationDataForCertificate(signingCertificate).getRevocationDate();
        }
        return null;
    }

    private Date getExpirationDateForSigningCertificate(SignatureWrapper currentSignature) {
        CertificateWrapper signingCertificate = currentSignature.getSigningCertificate();
        if (signingCertificate != null) {
            return signingCertificate.getNotAfter();
        }
        return null;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.indication;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.subIndication;
    }

    @Override
    protected List<XmlName> getPreviousErrors() {
        return this.errors;
    }
}

