/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlName;
import eu.europa.esig.dss.detailedreport.jaxb.XmlStatus;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.Level;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChainItem<T extends XmlConstraintsConclusion> {
    private static final Logger LOG = LoggerFactory.getLogger(ChainItem.class);
    private ChainItem<T> nextItem;
    private T result;
    protected final I18nProvider i18nProvider;
    private final LevelConstraint constraint;
    private String bbbId;

    protected ChainItem(I18nProvider i18nProvider, T result, LevelConstraint constraint) {
        this(i18nProvider, result, constraint, null);
    }

    protected ChainItem(I18nProvider i18nProvider, T result, LevelConstraint constraint, String bbbId) {
        Objects.requireNonNull(i18nProvider, "i18nProvider must be defined!");
        this.i18nProvider = i18nProvider;
        this.result = result;
        this.constraint = constraint;
        this.bbbId = bbbId;
    }

    public ChainItem<T> setNextItem(ChainItem<T> nextItem) {
        this.nextItem = nextItem;
        return nextItem;
    }

    public void execute() {
        if (this.constraint == null || this.constraint.getLevel() == null) {
            LOG.trace("Check skipped : constraint not defined");
            this.callNext();
        } else {
            switch (this.constraint.getLevel()) {
                case IGNORE: {
                    this.ignore();
                    break;
                }
                case FAIL: {
                    this.fail();
                    break;
                }
                case INFORM: 
                case WARN: {
                    this.informOrWarn(this.constraint.getLevel());
                    break;
                }
                default: {
                    LOG.warn("Unknown level : {}", (Object)this.constraint.getLevel());
                }
            }
        }
    }

    protected abstract boolean process();

    protected abstract MessageTag getMessageTag();

    protected abstract MessageTag getErrorMessageTag();

    protected List<XmlName> getPreviousErrors() {
        return Collections.emptyList();
    }

    protected abstract Indication getFailedIndicationForConclusion();

    protected abstract SubIndication getFailedSubIndicationForConclusion();

    private void recordIgnore() {
        this.recordConstraint(XmlStatus.IGNORED);
    }

    private void recordValid() {
        this.recordConstraint(XmlStatus.OK);
    }

    private void recordInvalid() {
        this.recordConstraint(XmlStatus.NOT_OK);
    }

    private void recordCustomSuccessConclusion() {
        XmlConclusion conclusion = new XmlConclusion();
        conclusion.setIndication(this.getSuccessIndication());
        conclusion.setSubIndication(this.getSuccessSubIndication());
        this.result.setConclusion(conclusion);
    }

    private void recordConclusion() {
        XmlConclusion conclusion = new XmlConclusion();
        conclusion.setIndication(this.getFailedIndicationForConclusion());
        conclusion.setSubIndication(this.getFailedSubIndicationForConclusion());
        List<XmlName> previousErrors = this.getPreviousErrors();
        if (Utils.isCollectionNotEmpty(previousErrors)) {
            conclusion.getErrors().addAll(previousErrors);
        } else {
            conclusion.getErrors().add(this.buildXmlName(this.getErrorMessageTag()));
        }
        this.result.setConclusion(conclusion);
    }

    private void recordInfosOrWarns(Level level) {
        if (Level.INFORM.equals((Object)level)) {
            this.recordConstraint(XmlStatus.INFORMATION);
        } else if (Level.WARN.equals((Object)level)) {
            this.recordConstraint(XmlStatus.WARNING);
        }
    }

    private void recordConstraint(XmlStatus status) {
        XmlConstraint xmlConstraint = new XmlConstraint();
        xmlConstraint.setName(this.buildXmlName(this.getMessageTag()));
        xmlConstraint.setStatus(status);
        xmlConstraint.setId(this.bbbId);
        if (XmlStatus.NOT_OK.equals((Object)status) || XmlStatus.WARNING.equals((Object)status) || XmlStatus.INFORMATION.equals((Object)status)) {
            if (XmlStatus.NOT_OK.equals((Object)status)) {
                xmlConstraint.setError(this.buildXmlName(this.getErrorMessageTag()));
            } else if (XmlStatus.WARNING.equals((Object)status)) {
                xmlConstraint.setWarning(this.buildXmlName(this.getErrorMessageTag()));
            } else if (XmlStatus.INFORMATION.equals((Object)status)) {
                xmlConstraint.setInfo(this.buildXmlName(this.getErrorMessageTag()));
            }
        }
        if (!XmlStatus.IGNORED.equals((Object)status)) {
            xmlConstraint.setAdditionalInfo(ValidationProcessUtils.buildStringMessage(this.i18nProvider, this.getAdditionalInfo()));
        }
        this.addConstraint(xmlConstraint);
    }

    protected MessageTag getAdditionalInfo() {
        return null;
    }

    private void addConstraint(XmlConstraint constraint) {
        this.result.getConstraint().add(constraint);
    }

    private XmlName buildXmlName(MessageTag messageTag) {
        XmlName xmlName = new XmlName();
        String message = this.i18nProvider.getMessage(messageTag);
        if (message != null) {
            xmlName.setNameId(messageTag.getId());
            xmlName.setValue(message);
        } else {
            LOG.error("MessageTag [{}] is not defined an messages.properties!", (Object)messageTag);
        }
        return xmlName;
    }

    private void fail() {
        boolean valid = this.process();
        if (valid) {
            this.recordValid();
            if (!this.isCustomSuccessConclusion()) {
                this.callNext();
            } else {
                this.recordCustomSuccessConclusion();
            }
        } else {
            this.recordInvalid();
            this.recordConclusion();
        }
    }

    private boolean isCustomSuccessConclusion() {
        return this.getSuccessIndication() != null;
    }

    protected Indication getSuccessIndication() {
        return null;
    }

    protected SubIndication getSuccessSubIndication() {
        return null;
    }

    private void informOrWarn(Level level) {
        boolean valid = this.process();
        if (valid) {
            this.recordValid();
        } else {
            this.recordInfosOrWarns(level);
        }
        this.callNext();
    }

    private void ignore() {
        this.recordIgnore();
        this.callNext();
    }

    private void callNext() {
        if (this.nextItem != null) {
            this.nextItem.execute();
        }
    }

    protected boolean isValid(XmlConstraintsConclusion constraintConclusion) {
        return constraintConclusion != null && this.isValidConclusion(constraintConclusion.getConclusion());
    }

    protected boolean isValidConclusion(XmlConclusion conclusion) {
        return conclusion != null && Indication.PASSED.equals((Object)conclusion.getIndication());
    }

    protected boolean isInvalidConclusion(XmlConclusion conclusion) {
        return conclusion != null && Indication.FAILED.equals((Object)conclusion.getIndication());
    }

    protected boolean isIndeterminateConclusion(XmlConclusion conclusion) {
        return conclusion != null && Indication.INDETERMINATE.equals((Object)conclusion.getIndication());
    }
}

