/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor.signature;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusionWithProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlDetailedReport;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSignature;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalData;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessBasicSignature;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessLongTermData;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationSignatureQualification;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationTimestampQualification;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.executor.AbstractDetailedReportBuilder;
import eu.europa.esig.dss.validation.executor.ValidationLevel;
import eu.europa.esig.dss.validation.process.qualification.signature.SignatureQualificationBlock;
import eu.europa.esig.dss.validation.process.qualification.timestamp.TimestampQualificationBlock;
import eu.europa.esig.dss.validation.process.vpfbs.ValidationProcessForBasicSignature;
import eu.europa.esig.dss.validation.process.vpfltvd.ValidationProcessForSignaturesWithLongTermValidationData;
import eu.europa.esig.dss.validation.process.vpfswatsp.ValidationProcessForSignaturesWithArchivalData;
import eu.europa.esig.dss.validation.process.vpftsp.ValidationProcessForTimeStamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DetailedReportBuilder
extends AbstractDetailedReportBuilder {
    private final ValidationLevel validationLevel;

    public DetailedReportBuilder(I18nProvider i18nProvider, Date currentTime, ValidationPolicy policy, ValidationLevel validationLevel, DiagnosticData diagnosticData) {
        super(i18nProvider, currentTime, policy, diagnosticData);
        this.validationLevel = validationLevel;
    }

    XmlDetailedReport build() {
        XmlDetailedReport detailedReport = this.init();
        detailedReport.setValidationTime(this.currentTime);
        List tlAnalysis = detailedReport.getTLAnalysis();
        Map<String, XmlBasicBuildingBlocks> bbbs = this.executeAllBasicBuildingBlocks();
        detailedReport.getBasicBuildingBlocks().addAll(bbbs.values());
        HashSet attachedTimestamps = new HashSet();
        for (SignatureWrapper signature : this.diagnosticData.getSignatures()) {
            CertificateWrapper signingCertificate;
            XmlSignature signatureAnalysis = new XmlSignature();
            signatureAnalysis.setId(signature.getId());
            if (signature.isCounterSignature()) {
                signatureAnalysis.setCounterSignature(Boolean.valueOf(true));
            }
            XmlValidationProcessBasicSignature validation = this.executeBasicValidation(signatureAnalysis, signature, bbbs);
            if (ValidationLevel.TIMESTAMPS.equals((Object)this.validationLevel)) {
                attachedTimestamps.addAll(signature.getTimestampIdsList());
                signatureAnalysis.getTimestamp().addAll(this.getXmlTimestamps(signature.getTimestampList(), bbbs, detailedReport.getTLAnalysis()));
            } else if (ValidationLevel.LONG_TERM_DATA.equals((Object)this.validationLevel)) {
                attachedTimestamps.addAll(signature.getTimestampIdsList());
                signatureAnalysis.getTimestamp().addAll(this.getXmlTimestamps(signature.getTimestampList(), bbbs, detailedReport.getTLAnalysis()));
                validation = this.executeLongTermValidation(signatureAnalysis, signature, bbbs);
            } else if (ValidationLevel.ARCHIVAL_DATA.equals((Object)this.validationLevel)) {
                attachedTimestamps.addAll(signature.getTimestampIdsList());
                signatureAnalysis.getTimestamp().addAll(this.getXmlTimestamps(signature.getTimestampList(), bbbs, detailedReport.getTLAnalysis()));
                this.executeLongTermValidation(signatureAnalysis, signature, bbbs);
                validation = this.executeArchiveValidation(signatureAnalysis, signature, bbbs);
            }
            if (this.policy.isEIDASConstraintPresent() && (signingCertificate = signature.getSigningCertificate()) != null) {
                SignatureQualificationBlock qualificationBlock = new SignatureQualificationBlock(this.i18nProvider, signature.getId(), (XmlConstraintsConclusionWithProofOfExistence)validation, signingCertificate, tlAnalysis);
                signatureAnalysis.setValidationSignatureQualification((XmlValidationSignatureQualification)qualificationBlock.execute());
            }
            detailedReport.getSignatureOrTimestampOrCertificate().add(signatureAnalysis);
        }
        if (!ValidationLevel.BASIC_SIGNATURES.equals((Object)this.validationLevel)) {
            for (TimestampWrapper timestamp : this.diagnosticData.getTimestampList()) {
                if (attachedTimestamps.contains(timestamp.getId())) continue;
                detailedReport.getSignatureOrTimestampOrCertificate().add(this.buildXmlTimestamp(timestamp, bbbs, tlAnalysis));
            }
        }
        return detailedReport;
    }

    private XmlValidationProcessBasicSignature executeBasicValidation(XmlSignature signatureAnalysis, SignatureWrapper signature, Map<String, XmlBasicBuildingBlocks> bbbs) {
        ValidationProcessForBasicSignature vpfbs = new ValidationProcessForBasicSignature(this.i18nProvider, this.diagnosticData, signature, bbbs);
        XmlValidationProcessBasicSignature bs = (XmlValidationProcessBasicSignature)vpfbs.execute();
        signatureAnalysis.setValidationProcessBasicSignature(bs);
        return bs;
    }

    private List<XmlTimestamp> getXmlTimestamps(List<TimestampWrapper> timestamps, Map<String, XmlBasicBuildingBlocks> bbbs, List<XmlTLAnalysis> tlAnalysis) {
        ArrayList<XmlTimestamp> results = new ArrayList<XmlTimestamp>();
        for (TimestampWrapper timestamp : timestamps) {
            results.add(this.buildXmlTimestamp(timestamp, bbbs, tlAnalysis));
        }
        return results;
    }

    private XmlTimestamp buildXmlTimestamp(TimestampWrapper timestamp, Map<String, XmlBasicBuildingBlocks> bbbs, List<XmlTLAnalysis> tlAnalysis) {
        XmlTimestamp xmlTimestamp = new XmlTimestamp();
        xmlTimestamp.setId(timestamp.getId());
        ValidationProcessForTimeStamp vpftsp = new ValidationProcessForTimeStamp(this.i18nProvider, this.diagnosticData, timestamp, bbbs);
        xmlTimestamp.setValidationProcessTimestamp((XmlValidationProcessTimestamp)vpftsp.execute());
        if (this.policy.isEIDASConstraintPresent()) {
            TimestampQualificationBlock timestampQualificationBlock = new TimestampQualificationBlock(this.i18nProvider, timestamp, tlAnalysis);
            xmlTimestamp.setValidationTimestampQualification((XmlValidationTimestampQualification)timestampQualificationBlock.execute());
        }
        return xmlTimestamp;
    }

    private XmlValidationProcessLongTermData executeLongTermValidation(XmlSignature signatureAnalysis, SignatureWrapper signature, Map<String, XmlBasicBuildingBlocks> bbbs) {
        ValidationProcessForSignaturesWithLongTermValidationData vpfltvd = new ValidationProcessForSignaturesWithLongTermValidationData(this.i18nProvider, signatureAnalysis, this.diagnosticData, signature, bbbs, this.policy, this.currentTime);
        XmlValidationProcessLongTermData vpfltvdResult = (XmlValidationProcessLongTermData)vpfltvd.execute();
        signatureAnalysis.setValidationProcessLongTermData(vpfltvdResult);
        return vpfltvdResult;
    }

    private XmlValidationProcessArchivalData executeArchiveValidation(XmlSignature signatureAnalysis, SignatureWrapper signature, Map<String, XmlBasicBuildingBlocks> bbbs) {
        ValidationProcessForSignaturesWithArchivalData vpfswad = new ValidationProcessForSignaturesWithArchivalData(this.i18nProvider, signatureAnalysis, signature, this.diagnosticData, bbbs, this.policy, this.currentTime);
        XmlValidationProcessArchivalData vpfswadResult = (XmlValidationProcessArchivalData)vpfswad.execute();
        signatureAnalysis.setValidationProcessArchivalData(vpfswadResult);
        return vpfswadResult;
    }

    private Map<String, XmlBasicBuildingBlocks> executeAllBasicBuildingBlocks() {
        LinkedHashMap<String, XmlBasicBuildingBlocks> bbbs = new LinkedHashMap<String, XmlBasicBuildingBlocks>();
        switch (this.validationLevel) {
            case ARCHIVAL_DATA: 
            case LONG_TERM_DATA: {
                this.process(this.diagnosticData.getAllRevocationData(), Context.REVOCATION, bbbs);
                this.process(this.diagnosticData.getTimestampList(), Context.TIMESTAMP, bbbs);
                this.process(this.diagnosticData.getAllSignatures(), Context.SIGNATURE, bbbs);
                this.process(this.diagnosticData.getAllCounterSignatures(), Context.COUNTER_SIGNATURE, bbbs);
                break;
            }
            case TIMESTAMPS: {
                this.process(this.diagnosticData.getTimestampList(), Context.TIMESTAMP, bbbs);
                this.process(this.diagnosticData.getAllSignatures(), Context.SIGNATURE, bbbs);
                this.process(this.diagnosticData.getAllCounterSignatures(), Context.COUNTER_SIGNATURE, bbbs);
                break;
            }
            case BASIC_SIGNATURES: {
                this.process(this.diagnosticData.getAllSignatures(), Context.SIGNATURE, bbbs);
                this.process(this.diagnosticData.getAllCounterSignatures(), Context.COUNTER_SIGNATURE, bbbs);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported validation level " + (Object)((Object)this.validationLevel));
            }
        }
        return bbbs;
    }
}

