/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks.type;

import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.qualification.EIDASUtils;
import eu.europa.esig.dss.validation.process.qualification.certificate.QualifiedStatus;
import eu.europa.esig.dss.validation.process.qualification.certificate.Type;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeStrategy;
import eu.europa.esig.dss.validation.process.qualification.trust.ServiceQualification;
import eu.europa.esig.dss.validation.reports.wrapper.TrustedServiceWrapper;
import java.util.List;

class TypeByTL
implements TypeStrategy {
    private final TrustedServiceWrapper trustedService;
    private final QualifiedStatus qualified;
    private final TypeStrategy typeInCert;

    public TypeByTL(TrustedServiceWrapper trustedService, QualifiedStatus qualified, TypeStrategy typeInCert) {
        this.trustedService = trustedService;
        this.qualified = qualified;
        this.typeInCert = typeInCert;
    }

    @Override
    public Type getType() {
        if (QualifiedStatus.isQC(this.qualified)) {
            if (EIDASUtils.isPreEIDAS(this.trustedService.getStartDate())) {
                return Type.ESIGN;
            }
            List<String> usageQualifiers = ServiceQualification.getUsageQualifiers(this.trustedService.getCapturedQualifiers());
            if (Utils.isCollectionNotEmpty(usageQualifiers)) {
                if (ServiceQualification.isQcForEsig(usageQualifiers)) {
                    return Type.ESIGN;
                }
                if (ServiceQualification.isQcForEseal(usageQualifiers)) {
                    return Type.ESEAL;
                }
                if (ServiceQualification.isQcForWSA(usageQualifiers)) {
                    return Type.WSA;
                }
            }
        }
        return this.typeInCert.getType();
    }
}

