/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks.type;

import eu.europa.esig.dss.validation.process.qualification.certificate.Type;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.QCTypeIdentifiers;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeStrategy;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;

class TypeByCertificatePostEIDAS
implements TypeStrategy {
    private final CertificateWrapper signingCertificate;

    public TypeByCertificatePostEIDAS(CertificateWrapper signingCertificate) {
        this.signingCertificate = signingCertificate;
    }

    @Override
    public Type getType() {
        boolean esign = QCTypeIdentifiers.isQCTypeEsign(this.signingCertificate);
        boolean eseal = QCTypeIdentifiers.isQCTypeEseal(this.signingCertificate);
        boolean web = QCTypeIdentifiers.isQCTypeWeb(this.signingCertificate);
        boolean noneType = !esign && !eseal && !web;
        boolean onlyOne = esign ^ eseal ^ web;
        if (noneType || esign && onlyOne) {
            return Type.ESIGN;
        }
        if (eseal && onlyOne) {
            return Type.ESEAL;
        }
        if (web && onlyOne) {
            return Type.WSA;
        }
        return Type.UNKNOWN;
    }
}

