/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd;

import eu.europa.esig.dss.validation.process.qualification.EIDASUtils;
import eu.europa.esig.dss.validation.process.qualification.certificate.QualifiedStatus;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDByCertificatePostEIDAS;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDByCertificatePreEIDAS;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDByTL;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDStrategy;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TrustedServiceWrapper;

public final class QSCDStrategyFactory {
    private QSCDStrategyFactory() {
    }

    public static QSCDStrategy createQSCDFromCert(CertificateWrapper signingCertificate) {
        if (EIDASUtils.isPostEIDAS(signingCertificate.getNotBefore())) {
            return new QSCDByCertificatePostEIDAS(signingCertificate);
        }
        return new QSCDByCertificatePreEIDAS(signingCertificate);
    }

    public static QSCDStrategy createQSCDFromTL(TrustedServiceWrapper trustedService, QualifiedStatus qualified, QSCDStrategy qscdFromCertificate) {
        return new QSCDByTL(trustedService, qualified, qscdFromCertificate);
    }

    public static QSCDStrategy createQSCDFromCertAndTL(CertificateWrapper signingCertificate, TrustedServiceWrapper caQcTrustedService, QualifiedStatus qualified) {
        QSCDStrategy qscdFromCert = QSCDStrategyFactory.createQSCDFromCert(signingCertificate);
        return QSCDStrategyFactory.createQSCDFromTL(caQcTrustedService, qualified, qscdFromCert);
    }
}

