/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor;

import eu.europa.esig.dss.jaxb.diagnostic.XmlOID;
import eu.europa.esig.dss.jaxb.diagnostic.XmlTrustedService;
import eu.europa.esig.dss.jaxb.diagnostic.XmlTrustedServiceProvider;
import eu.europa.esig.dss.jaxb.simplecertificatereport.SimpleCertificateReport;
import eu.europa.esig.dss.jaxb.simplecertificatereport.XmlChainItem;
import eu.europa.esig.dss.jaxb.simplecertificatereport.XmlRevocation;
import eu.europa.esig.dss.jaxb.simplecertificatereport.XmlSubject;
import eu.europa.esig.dss.jaxb.simplecertificatereport.XmlTrustAnchor;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.reports.DetailedReport;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.DiagnosticData;
import eu.europa.esig.dss.validation.reports.wrapper.RevocationWrapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SimpleReportForCertificateBuilder {
    private final DiagnosticData diagnosticData;
    private final DetailedReport detailedReport;
    private final Date currentTime;
    private final String certificateId;

    public SimpleReportForCertificateBuilder(DiagnosticData diagnosticData, DetailedReport detailedReport, Date currentTime, String certificateId) {
        this.diagnosticData = diagnosticData;
        this.detailedReport = detailedReport;
        this.currentTime = currentTime;
        this.certificateId = certificateId;
    }

    public SimpleCertificateReport build() {
        SimpleCertificateReport simpleReport = new SimpleCertificateReport();
        simpleReport.setValidationTime(this.currentTime);
        ArrayList<XmlChainItem> chain = new ArrayList<XmlChainItem>();
        CertificateWrapper certificate = this.diagnosticData.getUsedCertificateById(this.certificateId);
        XmlChainItem firstChainItem = this.getChainItem(certificate);
        this.addQualifications(firstChainItem);
        chain.add(firstChainItem);
        List certificateChainIds = certificate.getCertificateChainIds();
        for (String certId : certificateChainIds) {
            CertificateWrapper issuer = this.diagnosticData.getUsedCertificateById(certId);
            chain.add(this.getChainItem(issuer));
        }
        simpleReport.setChain(chain);
        return simpleReport;
    }

    private XmlChainItem getChainItem(CertificateWrapper certificate) {
        XmlChainItem item = new XmlChainItem();
        item.setId(certificate.getId());
        item.setSubject(this.getSubject(certificate));
        String signingCertificateId = certificate.getSigningCertificateId();
        if (Utils.isStringNotBlank((String)signingCertificateId)) {
            item.setIssuerId(signingCertificateId);
        }
        item.setNotBefore(certificate.getNotBefore());
        item.setNotAfter(certificate.getNotAfter());
        item.setKeyUsages(certificate.getKeyUsages());
        item.setExtendedKeyUsages(this.getReadable(certificate.getExtendedKeyUsages()));
        item.setAiaUrls(this.emptyToNull(certificate.getAuthorityInformationAccessUrls()));
        item.setOcspUrls(this.emptyToNull(certificate.getOCSPAccessUrls()));
        item.setCrlUrls(this.emptyToNull(certificate.getCRLDistributionPoints()));
        item.setCpsUrls(this.emptyToNull(certificate.getCpsUrls()));
        item.setPdsUrls(null);
        XmlRevocation revocation = new XmlRevocation();
        RevocationWrapper revocationData = certificate.getLatestRevocationData();
        if (revocationData != null) {
            revocation.setProductionDate(revocationData.getProductionDate());
            revocation.setRevocationDate(revocationData.getRevocationDate());
            revocation.setRevocationReason(revocationData.getReason());
        }
        item.setRevocation(revocation);
        if (certificate.isTrusted()) {
            List trustServiceProviders = certificate.getTrustServiceProviders();
            ArrayList<XmlTrustAnchor> trustAnchors = new ArrayList<XmlTrustAnchor>();
            for (XmlTrustedServiceProvider xmlTrustedServiceProvider : trustServiceProviders) {
                List trustedServices = xmlTrustedServiceProvider.getTrustedServices();
                Set<String> uniqueServiceNames = this.getUniqueServiceNames(trustedServices);
                for (String serviceName : uniqueServiceNames) {
                    XmlTrustAnchor trustAnchor = new XmlTrustAnchor();
                    trustAnchor.setCountryCode(xmlTrustedServiceProvider.getCountryCode());
                    trustAnchor.setTrustServiceProvider(xmlTrustedServiceProvider.getTSPName());
                    trustAnchor.setTrustServiceProviderRegistrationId(xmlTrustedServiceProvider.getTSPRegistrationIdentifier());
                    trustAnchor.setTrustServiceName(serviceName);
                    trustAnchors.add(trustAnchor);
                }
            }
            item.setTrustAnchors(trustAnchors);
        } else {
            item.setTrustAnchors(null);
        }
        item.setIndication(this.detailedReport.getCertificateXCVIndication(certificate.getId()));
        return item;
    }

    private List<String> getReadable(List<XmlOID> oids) {
        if (Utils.isCollectionNotEmpty(oids)) {
            ArrayList<String> result = new ArrayList<String>();
            for (XmlOID xmlOID : oids) {
                if (Utils.isStringNotEmpty((String)xmlOID.getDescription())) {
                    result.add(xmlOID.getDescription());
                    continue;
                }
                result.add(xmlOID.getValue());
            }
            return result;
        }
        return null;
    }

    private Set<String> getUniqueServiceNames(List<XmlTrustedService> trustedServices) {
        HashSet<String> result = new HashSet<String>();
        for (XmlTrustedService xmlTrustedService : trustedServices) {
            result.add(xmlTrustedService.getServiceName());
        }
        return result;
    }

    private XmlSubject getSubject(CertificateWrapper certificate) {
        XmlSubject subject = new XmlSubject();
        subject.setCommonName(certificate.getCommonName());
        subject.setPseudonym(certificate.getPseudo());
        subject.setSurname(certificate.getSurname());
        subject.setGivenName(certificate.getGivenName());
        subject.setOrganizationName(certificate.getOrganizationName());
        subject.setOrganizationUnit(certificate.getOrganizationalUnit());
        subject.setEmail(certificate.getEmail());
        subject.setLocality(certificate.getLocality());
        subject.setState(certificate.getState());
        subject.setCountry(certificate.getCountryName());
        return subject;
    }

    private List<String> emptyToNull(List<String> listUrls) {
        if (Utils.isCollectionEmpty(listUrls)) {
            return null;
        }
        return listUrls;
    }

    private void addQualifications(XmlChainItem firstChainItem) {
        firstChainItem.setQualificationAtIssuance(this.detailedReport.getCertificateQualificationAtIssuance());
        firstChainItem.setQualificationAtValidation(this.detailedReport.getCertificateQualificationAtValidation());
    }
}

