/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor;

import eu.europa.esig.dss.jaxb.detailedreport.DetailedReport;
import eu.europa.esig.dss.jaxb.detailedreport.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.jaxb.detailedreport.XmlCertificate;
import eu.europa.esig.dss.validation.executor.AbstractDetailedReportBuilder;
import eu.europa.esig.dss.validation.policy.Context;
import eu.europa.esig.dss.validation.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertificateQualificationBlock;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.DiagnosticData;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;

public class DetailedReportForCertificateBuilder
extends AbstractDetailedReportBuilder {
    private final String certificateId;

    public DetailedReportForCertificateBuilder(DiagnosticData diagnosticData, ValidationPolicy policy, Date currentTime, String certificateId) {
        super(diagnosticData, policy, currentTime);
        this.certificateId = certificateId;
    }

    DetailedReport build() {
        DetailedReport detailedReport = this.init();
        CertificateWrapper certificate = this.diagnosticData.getUsedCertificateById(this.certificateId);
        CertificateWrapper rootCertificate = this.diagnosticData.getUsedCertificateById(certificate.getLastChainCertificateId());
        HashMap<String, XmlBasicBuildingBlocks> bbbs = new HashMap<String, XmlBasicBuildingBlocks>();
        this.process(Collections.singleton(certificate), Context.CERTIFICATE, bbbs);
        detailedReport.getBasicBuildingBlocks().addAll(bbbs.values());
        XmlBasicBuildingBlocks basicBuildingBlocks = (XmlBasicBuildingBlocks)bbbs.get(certificate.getId());
        CertificateQualificationBlock cqb = new CertificateQualificationBlock(basicBuildingBlocks.getConclusion(), this.currentTime, certificate, rootCertificate, detailedReport.getTLAnalysis(), this.diagnosticData.getLOTLCountryCode());
        detailedReport.setCertificate((XmlCertificate)cqb.execute());
        return detailedReport;
    }
}

