/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor;

import eu.europa.esig.dss.jaxb.simplecertificatereport.SimpleCertificateReport;
import eu.europa.esig.dss.validation.executor.DetailedReportForCertificateBuilder;
import eu.europa.esig.dss.validation.executor.ProcessExecutor;
import eu.europa.esig.dss.validation.executor.SimpleReportForCertificateBuilder;
import eu.europa.esig.dss.validation.executor.ValidationLevel;
import eu.europa.esig.dss.validation.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.reports.CertificateReports;
import eu.europa.esig.dss.validation.reports.DetailedReport;
import eu.europa.esig.dss.validation.reports.wrapper.DiagnosticData;
import java.util.Date;
import java.util.Objects;

public class CertificateProcessExecutor
implements ProcessExecutor<CertificateReports> {
    private Date currentTime;
    private ValidationPolicy policy;
    private eu.europa.esig.dss.jaxb.diagnostic.DiagnosticData jaxbDiagnosticData;
    private String certificateId;

    @Override
    public void setCurrentTime(Date currentTime) {
        this.currentTime = currentTime;
    }

    @Override
    public Date getCurrentTime() {
        return this.currentTime;
    }

    @Override
    public void setDiagnosticData(eu.europa.esig.dss.jaxb.diagnostic.DiagnosticData diagnosticData) {
        this.jaxbDiagnosticData = diagnosticData;
    }

    @Override
    public void setValidationPolicy(ValidationPolicy validationPolicy) {
        this.policy = validationPolicy;
    }

    @Override
    public ValidationPolicy getValidationPolicy() {
        return this.policy;
    }

    public void setCertificateId(String certificateId) {
        this.certificateId = certificateId;
    }

    @Override
    public void setValidationLevel(ValidationLevel validationLevel) {
    }

    @Override
    public CertificateReports execute() {
        Objects.requireNonNull(this.jaxbDiagnosticData, "The diagnostic data is missing");
        Objects.requireNonNull(this.policy, "The validation policy is missing");
        Objects.requireNonNull(this.currentTime, "The current time is missing");
        DiagnosticData diagnosticData = new DiagnosticData(this.jaxbDiagnosticData);
        DetailedReportForCertificateBuilder detailedReportBuilder = new DetailedReportForCertificateBuilder(diagnosticData, this.policy, this.currentTime, this.certificateId);
        eu.europa.esig.dss.jaxb.detailedreport.DetailedReport detailedReport = detailedReportBuilder.build();
        SimpleReportForCertificateBuilder simpleReportBuilder = new SimpleReportForCertificateBuilder(diagnosticData, new DetailedReport(detailedReport), this.currentTime, this.certificateId);
        SimpleCertificateReport simpleReport = simpleReportBuilder.build();
        return new CertificateReports(this.jaxbDiagnosticData, detailedReport, simpleReport);
    }
}

