/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfltvd.checks;

import eu.europa.esig.dss.jaxb.detailedreport.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.jaxb.detailedreport.XmlCV;
import eu.europa.esig.dss.jaxb.detailedreport.XmlConclusion;
import eu.europa.esig.dss.jaxb.detailedreport.XmlISC;
import eu.europa.esig.dss.jaxb.detailedreport.XmlName;
import eu.europa.esig.dss.jaxb.detailedreport.XmlSAV;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationProcessLongTermData;
import eu.europa.esig.dss.jaxb.detailedreport.XmlXCV;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.policy.rules.SubIndication;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import eu.europa.esig.jaxb.policy.LevelConstraint;
import java.util.List;

public class RevocationBasicBuildingBlocksCheck
extends ChainItem<XmlValidationProcessLongTermData> {
    private final XmlBasicBuildingBlocks revocationBBB;
    private Indication indication;
    private SubIndication subIndication;
    private List<XmlName> errors;

    public RevocationBasicBuildingBlocksCheck(XmlValidationProcessLongTermData result, XmlBasicBuildingBlocks revocationBBB, LevelConstraint constraint) {
        super(result, constraint, revocationBBB.getId());
        this.revocationBBB = revocationBBB;
    }

    @Override
    protected boolean process() {
        XmlISC isc = this.revocationBBB.getISC();
        XmlConclusion iscConclusion = isc.getConclusion();
        if (!this.isAllowed(iscConclusion)) {
            this.indication = iscConclusion.getIndication();
            this.subIndication = iscConclusion.getSubIndication();
            this.errors = iscConclusion.getErrors();
            return false;
        }
        XmlCV cv = this.revocationBBB.getCV();
        XmlConclusion cvConclusion = cv.getConclusion();
        if (!this.isAllowed(cvConclusion)) {
            this.indication = cvConclusion.getIndication();
            this.subIndication = cvConclusion.getSubIndication();
            this.errors = cvConclusion.getErrors();
            return false;
        }
        XmlXCV xcv = this.revocationBBB.getXCV();
        XmlConclusion xcvConclusion = xcv.getConclusion();
        if (!this.isAllowed(xcvConclusion)) {
            this.indication = xcvConclusion.getIndication();
            this.subIndication = xcvConclusion.getSubIndication();
            this.errors = xcvConclusion.getErrors();
            return false;
        }
        XmlSAV sav = this.revocationBBB.getSAV();
        XmlConclusion savConclusion = sav.getConclusion();
        if (!this.isAllowed(savConclusion)) {
            this.indication = savConclusion.getIndication();
            this.subIndication = savConclusion.getSubIndication();
            this.errors = savConclusion.getErrors();
            return false;
        }
        return true;
    }

    private boolean isAllowed(XmlConclusion conclusion) {
        boolean allowed = Indication.PASSED.equals((Object)conclusion.getIndication()) || Indication.INDETERMINATE.equals((Object)conclusion.getIndication()) && (SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.REVOKED_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NO_POE.equals((Object)conclusion.getSubIndication()));
        return allowed;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ADEST_RORPIIC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.ADEST_RORPIIC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.indication;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.subIndication;
    }

    @Override
    protected List<XmlName> getPreviousErrors() {
        return this.errors;
    }
}

