/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfltvd.checks;

import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationProcessLongTermData;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.policy.rules.SubIndication;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.jaxb.policy.LevelConstraint;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BestSignatureTimeNotBeforeCertificateIssuanceCheck
extends ChainItem<XmlValidationProcessLongTermData> {
    private final Date bestSignatureTime;
    private final CertificateWrapper signingCertificate;

    public BestSignatureTimeNotBeforeCertificateIssuanceCheck(XmlValidationProcessLongTermData result, Date bestSignatureTime, CertificateWrapper signingCertificate, LevelConstraint constraint) {
        super(result, constraint);
        this.bestSignatureTime = bestSignatureTime;
        this.signingCertificate = signingCertificate;
    }

    @Override
    protected boolean process() {
        return !this.bestSignatureTime.before(this.signingCertificate.getNotBefore());
    }

    @Override
    protected String getAdditionalInfo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String bestSignatureTimeStr = this.bestSignatureTime == null ? " ? " : sdf.format(this.bestSignatureTime);
        return MessageFormat.format("Best signature time : {0}", bestSignatureTimeStr);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.TSV_IBSTAIDOSC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.TSV_IBSTAIDOSC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.NOT_YET_VALID;
    }

    @Override
    protected Indication getSuccessIndication() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getSuccessSubIndication() {
        return SubIndication.OUT_OF_BOUNDS_NO_POE;
    }
}

