/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.type.tl;

import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.ServiceQualification;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.type.Type;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.type.TypeStrategy;
import eu.europa.esig.dss.validation.reports.wrapper.TrustedServiceWrapper;
import java.util.List;

public class TypeByTL
implements TypeStrategy {
    private final List<TrustedServiceWrapper> trustedServices;
    private final TypeStrategy typeInCert;

    public TypeByTL(List<TrustedServiceWrapper> trustedServices, TypeStrategy typeInCert) {
        this.trustedServices = trustedServices;
        this.typeInCert = typeInCert;
    }

    @Override
    public Type getType() {
        if (Utils.isCollectionNotEmpty(this.trustedServices)) {
            for (TrustedServiceWrapper trustedService : this.trustedServices) {
                List<String> usageQualifiers = ServiceQualification.getUsageQualifiers(trustedService.getCapturedQualifiers());
                if (!Utils.isCollectionNotEmpty(usageQualifiers)) continue;
                if (ServiceQualification.isQcForEsig(usageQualifiers)) {
                    return Type.ESIGN;
                }
                if (!ServiceQualification.isQcForEseal(usageQualifiers) && !ServiceQualification.isQcForWSA(usageQualifiers)) continue;
                return Type.ESEAL;
            }
        }
        return this.typeInCert.getType();
    }
}

