/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.type;

import eu.europa.esig.dss.validation.process.qmatrix.EIDASUtils;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.type.TypeStrategy;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.type.cert.TypeByCertificatePostEIDAS;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.type.cert.TypeByCertificatePreEIDAS;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.type.tl.TypeByTL;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TrustedServiceWrapper;
import java.util.List;

public final class TypeStrategyFactory {
    private TypeStrategyFactory() {
    }

    public static TypeStrategy createTypeFromCert(CertificateWrapper signingCertificate) {
        if (EIDASUtils.isPostEIDAS(signingCertificate.getNotBefore())) {
            return new TypeByCertificatePostEIDAS(signingCertificate);
        }
        return new TypeByCertificatePreEIDAS(signingCertificate);
    }

    public static TypeStrategy createTypeFromTL(List<TrustedServiceWrapper> trustedServices, TypeStrategy typeInCert) {
        return new TypeByTL(trustedServices, typeInCert);
    }
}

