/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.type;

import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.filter.TrustedServiceFilter;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.filter.TrustedServicesFilterFactory;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.type.Type;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.type.TypeStrategy;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.type.TypeStrategyFactory;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TrustedServiceWrapper;
import java.util.Date;
import java.util.List;

public class TypeFromCertAndTL
implements TypeStrategy {
    private final CertificateWrapper signingCertificate;
    private final List<TrustedServiceWrapper> caqcServices;
    private final Date date;

    public TypeFromCertAndTL(CertificateWrapper signingCertificate, List<TrustedServiceWrapper> caqcServices, Date date) {
        this.signingCertificate = signingCertificate;
        this.caqcServices = caqcServices;
        this.date = date;
    }

    @Override
    public Type getType() {
        TrustedServiceFilter filterByDate = TrustedServicesFilterFactory.createFilterByDate(this.date);
        List<TrustedServiceWrapper> servicesAtGivenDate = filterByDate.filter(this.caqcServices);
        TypeStrategy typeInCert = TypeStrategyFactory.createTypeFromCert(this.signingCertificate);
        TypeStrategy typeFromCertAndTL = TypeStrategyFactory.createTypeFromTL(servicesAtGivenDate, typeInCert);
        return typeFromCertAndTL.getType();
    }
}

