/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.qscd.tl;

import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Condition;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.ServiceQualification;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.qscd.AbstractQSCDCondition;
import eu.europa.esig.dss.validation.reports.wrapper.TrustedServiceWrapper;
import java.util.Collection;
import java.util.List;

public class QSCDByTL
extends AbstractQSCDCondition {
    private final List<TrustedServiceWrapper> trustedServices;
    private final Condition qualified;
    private final Condition qscdFromCertificate;

    public QSCDByTL(List<TrustedServiceWrapper> trustedServices, Condition qualified, Condition qscdFromCertificate) {
        this.trustedServices = trustedServices;
        this.qualified = qualified;
        this.qscdFromCertificate = qscdFromCertificate;
    }

    @Override
    public boolean check() {
        if (Utils.isCollectionEmpty(this.trustedServices) || !this.qualified.check()) {
            return false;
        }
        for (TrustedServiceWrapper trustedService : this.trustedServices) {
            List capturedQualifiers = trustedService.getCapturedQualifiers();
            if (!Utils.isCollectionNotEmpty((Collection)capturedQualifiers)) continue;
            if (ServiceQualification.isQcNoQSCD(capturedQualifiers)) {
                return false;
            }
            if (!ServiceQualification.isQcWithQSCD(capturedQualifiers) && !ServiceQualification.isQcQSCDManagedOnBehalf(capturedQualifiers)) continue;
            return true;
        }
        return this.qscdFromCertificate.check();
    }
}

